/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.web;

import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class FileUploadLogger {
    public static void logFileUploadInfo(HttpServletRequest request) {
        boolean multipartContent = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        System.out.println("multipartContent=" + multipartContent);
        if (!multipartContent) {
            return;
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)factory);
        try {
            FileItemIterator itemIterator = servletFileUpload.getItemIterator(request);
            while (itemIterator.hasNext()) {
                FileItemStream next = itemIterator.next();
                System.out.println("FileItemStream: " + next.getName());
                System.out.println("\t" + next.getContentType());
                System.out.println("\t" + next.getFieldName());
                FileItemHeaders headers = next.getHeaders();
                if (headers == null) continue;
                System.out.println("\t" + Arrays.toString(Iterators.toArray((Iterator)headers.getHeaderNames(), String.class)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

