/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.version;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Resource;
import org.jasig.portal.shell.PortalShellBuildHelper;
import org.jasig.portal.version.VersionUtils;
import org.jasig.portal.version.VersionVerifier;
import org.jasig.portal.version.dao.VersionDao;
import org.jasig.portal.version.om.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContextException;
import org.springframework.stereotype.Component;

@Component
public class VersionVerifier
implements InitializingBean {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, Version> requiredProductVersions;
    private VersionDao versionDao;
    private Version.Field updatePolicy = Version.Field.LOCAL;
    private PortalShellBuildHelper portalShellBuildHelper;

    @Resource(name="productVersions")
    public void setRequiredProductVersions(Map<String, Version> requiredProductVersions) {
        this.requiredProductVersions = ImmutableMap.copyOf(requiredProductVersions);
    }

    @Autowired
    public void setVersionDao(VersionDao versionDao) {
        this.versionDao = versionDao;
    }

    @Autowired
    public void setPortalShellBuildHelper(PortalShellBuildHelper portalShellBuildHelper) {
        this.portalShellBuildHelper = portalShellBuildHelper;
    }

    @Value(value="${org.jasig.portal.version.autoUpdatePolicy:LOCAL}")
    public void setUpdatePolicy(Version.Field updatePolicy) {
        if (updatePolicy != null && updatePolicy != Version.Field.LOCAL && updatePolicy != Version.Field.PATCH) {
            throw new IllegalArgumentException("Only null, LOCAL, and PATCH updates are allowed");
        }
        this.updatePolicy = updatePolicy;
    }

    public void afterPropertiesSet() throws Exception {
        block4: for (Map.Entry productVersionEntry : this.requiredProductVersions.entrySet()) {
            String product = (String)productVersionEntry.getKey();
            Version dbVersion = this.versionDao.getVersion(product);
            if (dbVersion == null) {
                throw new ApplicationContextException("No Version exists for " + product + " in the database. Please check the upgrade instructions for this release.");
            }
            Version codeVersion = (Version)productVersionEntry.getValue();
            Version.Field mostSpecificMatchingField = VersionUtils.getMostSpecificMatchingField((Version)dbVersion, (Version)codeVersion);
            switch (1.$SwitchMap$org$jasig$portal$version$om$Version$Field[mostSpecificMatchingField.ordinal()]) {
                case 1: {
                    this.logger.info("Software and Database versions are both {} for {}", (Object)dbVersion, (Object)product);
                    continue block4;
                }
                case 2: 
                case 3: {
                    Version.Field upgradeField = mostSpecificMatchingField.getLessImportant();
                    if (dbVersion.isBefore(codeVersion) && this.updatePolicy != null && (upgradeField.equals((Object)this.updatePolicy) || upgradeField.isLessImportantThan(this.updatePolicy))) {
                        this.logger.info("Automatically updating database from {} to {} for {}", new Object[]{dbVersion, codeVersion, product});
                        this.portalShellBuildHelper.hibernateUpdate("automated-hibernate-update", product, true, null);
                        continue block4;
                    }
                    if (!codeVersion.isBefore(dbVersion)) break;
                    continue block4;
                }
            }
            if (dbVersion.isBefore(codeVersion)) {
                throw new ApplicationContextException("Database Version for " + product + " is " + dbVersion + " but the code version is " + codeVersion + ". Please check the upgrade instructions for this release");
            }
            throw new ApplicationContextException("Database Version for " + product + " is " + dbVersion + " but the code version is " + codeVersion + ". It is not possible to run ");
        }
    }
}

