/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ResourceLoaderURIResolver
implements URIResolver {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ResourceLoader resourceLoader;

    public ResourceLoaderURIResolver(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        Resource resolvedResource = this.resolveResource(href, base);
        return this.createSource(resolvedResource, base);
    }

    protected Source createSource(Resource resolvedResource, String base) throws TransformerException {
        InputStream resourceStream;
        try {
            resourceStream = resolvedResource.getInputStream();
        }
        catch (IOException e) {
            throw new TransformerException("Failed to get InputStream for " + resolvedResource, e);
        }
        StreamSource streamSource = new StreamSource(resourceStream);
        streamSource.setSystemId(base);
        return streamSource;
    }

    protected Resource resolveResource(String href, String base) throws TransformerException {
        Resource resolvedResource;
        if (base != null) {
            Resource baseResource = this.resourceLoader.getResource(base);
            try {
                resolvedResource = baseResource.createRelative(href);
            }
            catch (IOException e) {
                throw new TransformerException("Failed to find '" + href + "' relative to: " + baseResource, e);
            }
            this.logger.debug("Created resource {} for href: {} and base: {}", new Object[]{resolvedResource, href, baseResource});
        } else {
            resolvedResource = this.resourceLoader.getResource(href);
            this.logger.debug("Created resource {} for href: {}", (Object)resolvedResource, (Object)href);
        }
        return resolvedResource;
    }
}

