/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.xml;

import com.ctc.wstx.api.EmptyElementHandler;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.cache.resource.CachedResource;
import org.jasig.portal.utils.cache.resource.CachingResourceLoader;
import org.jasig.portal.utils.cache.resource.Loader;
import org.jasig.portal.utils.cache.resource.TemplatesBuilder;
import org.jasig.portal.xml.XmlUtilities;
import org.jasig.portal.xml.stream.IndentingXMLEventWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Service
public class XmlUtilitiesImpl
implements XmlUtilities {
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newFactory();
    private final XMLOutputFactory htmlOutputFactory;
    private final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private TemplatesBuilder templatesBuilder;
    private CachingResourceLoader cachingResourceLoader;

    public XmlUtilitiesImpl() {
        this.htmlOutputFactory = XMLOutputFactory.newFactory();
        this.htmlOutputFactory.setProperty("com.ctc.wstx.outputEmptyElementHandler", EmptyElementHandler.HtmlEmptyElementHandler.getInstance());
    }

    @Autowired
    public void setCachingResourceLoader(CachingResourceLoader cachingResourceLoader) {
        this.cachingResourceLoader = cachingResourceLoader;
    }

    @Autowired
    public void setTemplatesBuilder(TemplatesBuilder templatesBuilder) {
        this.templatesBuilder = templatesBuilder;
    }

    public Templates getTemplates(Resource stylesheet) throws TransformerConfigurationException, IOException {
        CachedResource templates = this.getStylesheetCachedResource(stylesheet);
        return (Templates)templates.getCachedResource();
    }

    public Transformer getTransformer(Resource stylesheet) throws TransformerConfigurationException, IOException {
        Templates templates = this.getTemplates(stylesheet);
        return templates.newTransformer();
    }

    public Transformer getIdentityTransformer() throws TransformerConfigurationException, IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        return transformerFactory.newTransformer();
    }

    public Serializable getStylesheetCacheKey(Resource stylesheet) throws TransformerConfigurationException, IOException {
        CachedResource templates = this.getStylesheetCachedResource(stylesheet);
        return templates.getCacheKey();
    }

    public XMLOutputFactory getXmlOutputFactory() {
        return this.xmlOutputFactory;
    }

    public XMLOutputFactory getHtmlOutputFactory() {
        return this.htmlOutputFactory;
    }

    public XMLInputFactory getXmlInputFactory() {
        return this.xmlInputFactory;
    }

    public String serializeXMLEvents(List<XMLEvent> xmlEvents) {
        return this.serializeXMLEvents(xmlEvents, false);
    }

    public String serializeXMLEvents(List<XMLEvent> xmlEvents, boolean isHtml) {
        IndentingXMLEventWriter xmlEventWriter;
        XMLOutputFactory outputFactory = isHtml ? this.getHtmlOutputFactory() : this.getXmlOutputFactory();
        StringWriter writer = new StringWriter();
        try {
            xmlEventWriter = new IndentingXMLEventWriter(outputFactory.createXMLEventWriter(writer));
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Failed to create XMLEventWriter", e);
        }
        try {
            for (XMLEvent bufferedEvent : xmlEvents) {
                xmlEventWriter.add(bufferedEvent);
            }
            xmlEventWriter.flush();
            xmlEventWriter.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Failed to write XMLEvents to XMLEventWriter", e);
        }
        return writer.toString();
    }

    public Node convertToDom(XMLEventReader xmlEventReader) throws XMLStreamException {
        xmlEventReader = new /* Unavailable Anonymous Inner Class!! */;
        XMLOutputFactory xmlOutputFactory = this.getXmlOutputFactory();
        DOMResult sourceDom = new DOMResult(DocumentFactory.getThreadDocument());
        XMLEventWriter sourceWriter = xmlOutputFactory.createXMLEventWriter(sourceDom);
        sourceWriter.add(xmlEventReader);
        sourceWriter.flush();
        sourceWriter.close();
        return sourceDom.getNode();
    }

    public String getUniqueXPath(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Node cannot be null");
        }
        StringBuilder path = new StringBuilder();
        while (node != null && node.getNodeType() == 1) {
            int elementIndex = this.getElementIndex(node);
            String nodeName = node.getNodeName();
            if (elementIndex > 1) {
                path.insert(0, "]").insert(0, elementIndex).insert(0, "[");
            }
            path.insert(0, nodeName).insert(0, "/");
            node = node.getParentNode();
        }
        return path.toString();
    }

    private int getElementIndex(Node node) {
        String nodeName = node.getNodeName();
        int count = 1;
        for (Node previousSibling = node.getPreviousSibling(); previousSibling != null; previousSibling = previousSibling.getPreviousSibling()) {
            if (previousSibling.getNodeType() != 1 || !previousSibling.getNodeName().equals(nodeName)) continue;
            ++count;
        }
        return count;
    }

    private CachedResource<Templates> getStylesheetCachedResource(Resource stylesheet) throws IOException {
        return this.cachingResourceLoader.getResource(stylesheet, (Loader)this.templatesBuilder);
    }

    public static String getElementText(Element e) {
        StringBuilder val = new StringBuilder();
        for (Node n = e.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 3 && n.getNodeType() != 4) continue;
            val.append(n.getNodeValue());
        }
        return val.toString();
    }

    public static String toString(Node node) {
        Transformer identityTransformer;
        try {
            identityTransformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Failed to create identity transformer to serialize Node to String", e);
        }
        identityTransformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter outputWriter = new StringWriter();
        StreamResult outputTarget = new StreamResult(outputWriter);
        DOMSource xmlSource = new DOMSource(node);
        try {
            identityTransformer.transform(xmlSource, outputTarget);
        }
        catch (TransformerException e) {
            throw new RuntimeException("Failed to convert Node to String using Transformer", e);
        }
        return outputWriter.toString();
    }

    public static String toString(XMLEvent event) {
        StringWriter writer = new StringWriter();
        try {
            event.writeAsEncodedUnicode(writer);
        }
        catch (XMLStreamException e) {
            writer.write(event.toString());
        }
        return writer.toString();
    }
}

