/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.xml.stream;

import java.util.Deque;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang.StringUtils;
import org.jasig.portal.xml.stream.EventWriterDelegate;
import org.jasig.portal.xml.stream.IndentingXMLEventWriter;

/*
 * Exception performing whole class analysis ignored.
 */
public class IndentingXMLEventWriter
extends EventWriterDelegate {
    public static final String NEW_LINE = "\n";
    private static final ConcurrentMap<Integer, String> indentCache = new ConcurrentHashMap();
    private final XMLEventFactory xmlEventFactory;
    private int indentSize = 2;
    private final Deque<Set<StackState>> scopeState = new LinkedList();
    private int depth = 0;

    public IndentingXMLEventWriter(XMLEventWriter out) {
        super(out);
        this.xmlEventFactory = XMLEventFactory.newFactory();
        this.scopeState.add(EnumSet.noneOf(StackState.class));
    }

    public void setIndentSize(int indentSize) {
        this.indentSize = indentSize;
    }

    public static String getLineSeparator() {
        try {
            return System.getProperty("line.separator");
        }
        catch (SecurityException securityException) {
            return "\n";
        }
    }

    public void add(XMLEvent event) throws XMLStreamException {
        switch (event.getEventType()) {
            case 4: 
            case 6: 
            case 12: {
                this.wrappedWriter.add(event);
                this.afterData();
                return;
            }
            case 1: {
                this.beforeStartElement();
                this.wrappedWriter.add(event);
                this.afterStartElement();
                return;
            }
            case 2: {
                this.beforeEndElement();
                this.wrappedWriter.add(event);
                this.afterEndElement();
                return;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: {
                this.beforeMarkup();
                this.wrappedWriter.add(event);
                this.afterMarkup();
                return;
            }
            case 8: {
                this.wrappedWriter.add(event);
                this.afterEndDocument();
                break;
            }
            default: {
                this.wrappedWriter.add(event);
                return;
            }
        }
    }

    protected void beforeMarkup() {
        Set state = (Set)this.scopeState.getFirst();
        if (!(state.contains(StackState.WROTE_DATA) || this.depth <= 0 && state.isEmpty())) {
            String indent = this.getIndent(this.depth, this.indentSize);
            Characters indentEvent = this.xmlEventFactory.createCharacters(indent);
            try {
                this.wrappedWriter.add(indentEvent);
            }
            catch (XMLStreamException e) {
                // empty catch block
            }
            this.afterMarkup();
        }
    }

    protected void afterMarkup() {
        Set state = (Set)this.scopeState.getFirst();
        state.add(StackState.WROTE_MARKUP);
    }

    protected void afterData() {
        Set state = (Set)this.scopeState.getFirst();
        state.add(StackState.WROTE_DATA);
    }

    protected void beforeStartElement() {
        this.beforeMarkup();
    }

    protected void afterStartElement() {
        this.afterMarkup();
        ++this.depth;
        this.scopeState.push(EnumSet.noneOf(StackState.class));
    }

    protected void beforeEndElement() {
        Set state = (Set)this.scopeState.getFirst();
        if (this.depth > 0 && state.contains(StackState.WROTE_MARKUP) && !state.contains(StackState.WROTE_DATA)) {
            String indent = this.getIndent(this.depth - 1, this.indentSize);
            Characters indentEvent = this.xmlEventFactory.createCharacters(indent);
            try {
                this.wrappedWriter.add(indentEvent);
            }
            catch (XMLStreamException e) {
                // empty catch block
            }
        }
    }

    protected void afterEndElement() {
        if (this.depth > 0) {
            --this.depth;
            this.scopeState.pop();
        }
    }

    protected void afterEndDocument() {
        this.depth = 0;
        Set state = (Set)this.scopeState.getFirst();
        if (state.contains(StackState.WROTE_MARKUP) && !state.contains(StackState.WROTE_DATA)) {
            try {
                String indent = IndentingXMLEventWriter.getLineSeparator() + StringUtils.repeat((String)"  ", (int)0);
                Characters indentEvent = this.xmlEventFactory.createCharacters(indent);
                this.wrappedWriter.add(indentEvent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.scopeState.clear();
        this.scopeState.push(EnumSet.noneOf(StackState.class));
    }

    protected String getIndent(int depth, int size) {
        int length = depth * size;
        String indent = (String)indentCache.get(length);
        if (indent == null) {
            indent = IndentingXMLEventWriter.getLineSeparator() + StringUtils.repeat((String)" ", (int)length);
            indentCache.put(length, indent);
        }
        return indent;
    }
}

