/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.xml.xpath;

import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XPathExpressionFactory
extends BaseKeyedPoolableObjectFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final XPathFactory xPathFactory = XPathFactory.newInstance();
    private final NamespaceContext namespaceContext;
    private final XPathVariableResolver variableResolver;

    public XPathExpressionFactory(NamespaceContext namespaceContext, XPathVariableResolver variableResolver) {
        this.namespaceContext = namespaceContext;
        this.variableResolver = variableResolver;
    }

    public synchronized Object makeObject(Object key) throws Exception {
        String expression = (String)key;
        XPath xPath = this.xPathFactory.newXPath();
        if (this.namespaceContext != null) {
            xPath.setNamespaceContext(this.namespaceContext);
        }
        if (this.variableResolver != null) {
            xPath.setXPathVariableResolver(this.variableResolver);
        }
        this.logger.debug("Compiling XPathExpression from: {}", (Object)expression);
        try {
            return xPath.compile(expression);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Failed to compile XPath expression '" + expression + "'", e);
        }
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        String expression = (String)key;
        this.logger.debug("Destroying XPathExpression: {}", (Object)expression);
    }
}

