/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.xml.xpath;

import com.google.common.base.Function;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.jasig.portal.xml.xpath.ThreadLocalXPathVariableResolver;
import org.jasig.portal.xml.xpath.XPathExpressionFactory;
import org.jasig.portal.xml.xpath.XPathOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Service;

@Service
public class XPathPoolImpl
implements XPathOperations,
DisposableBean {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ThreadLocalXPathVariableResolver variableResolver = new ThreadLocalXPathVariableResolver();
    private final XPathExpressionFactory xpathExpressionfactory;
    private final NamespaceContext namespaceContext;
    private final GenericKeyedObjectPool pool;

    public XPathPoolImpl() {
        this(null);
    }

    public XPathPoolImpl(NamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
        this.xpathExpressionfactory = new XPathExpressionFactory(this.namespaceContext, (XPathVariableResolver)this.variableResolver);
        this.pool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)this.xpathExpressionfactory);
        this.pool.setMaxActive(500);
        this.pool.setMaxIdle(500);
        this.pool.setTimeBetweenEvictionRunsMillis(TimeUnit.SECONDS.toMillis(60L));
        this.pool.setMinEvictableIdleTimeMillis(TimeUnit.MINUTES.toMillis(5L));
        this.pool.setNumTestsPerEvictionRun(this.pool.getMaxIdle() / 9);
        this.pool.setWhenExhaustedAction((byte)0);
    }

    public void destroy() throws Exception {
        this.pool.close();
    }

    public <T> T doWithExpression(String expression, Function<XPathExpression, T> callback) {
        return (T)this.doWithExpression(expression, null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T doWithExpression(String expression, Map<String, ?> variables, Function<XPathExpression, T> callback) {
        try {
            XPathExpression xPathExpression = (XPathExpression)this.pool.borrowObject((Object)expression);
            try {
                this.variableResolver.setVariables(variables);
                Object object = callback.apply((Object)xPathExpression);
                return (T)object;
            }
            finally {
                this.variableResolver.clearVariables();
                this.pool.returnObject((Object)expression, (Object)xPathExpression);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception of type " + e.getClass().getName() + " is not expected", e);
        }
    }

    public <T> T evaluate(String expression, Object item, QName returnType) {
        return (T)this.evaluate(expression, null, item, returnType);
    }

    public <T> T evaluate(String expression, Map<String, ?> variables, Object item, QName returnType) {
        return (T)this.doWithExpression(expression, variables, (Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void clear() {
        this.pool.clear();
    }

    public void clearOldest() {
        this.pool.clearOldest();
    }

    public void close() throws Exception {
        this.pool.close();
    }

    public void evict() throws Exception {
        this.pool.evict();
    }

    public boolean getLifo() {
        return this.pool.getLifo();
    }

    public int getMaxActive() {
        return this.pool.getMaxActive();
    }

    public int getMaxIdle() {
        return this.pool.getMaxIdle();
    }

    public int getMaxTotal() {
        return this.pool.getMaxTotal();
    }

    public long getMaxWait() {
        return this.pool.getMaxWait();
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.pool.getMinEvictableIdleTimeMillis();
    }

    public int getMinIdle() {
        return this.pool.getMinIdle();
    }

    public int getNumActive() {
        return this.pool.getNumActive();
    }

    public int getNumIdle() {
        return this.pool.getNumIdle();
    }

    public int getNumTestsPerEvictionRun() {
        return this.pool.getNumTestsPerEvictionRun();
    }

    public boolean getTestOnBorrow() {
        return this.pool.getTestOnBorrow();
    }

    public boolean getTestOnReturn() {
        return this.pool.getTestOnReturn();
    }

    public boolean getTestWhileIdle() {
        return this.pool.getTestWhileIdle();
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.pool.getTimeBetweenEvictionRunsMillis();
    }

    public byte getWhenExhaustedAction() {
        return this.pool.getWhenExhaustedAction();
    }

    public void setLifo(boolean lifo) {
        this.pool.setLifo(lifo);
    }

    public void setMaxActive(int maxActive) {
        this.pool.setMaxActive(maxActive);
    }

    public void setMaxIdle(int maxIdle) {
        this.pool.setMaxIdle(maxIdle);
    }

    public void setMaxTotal(int maxTotal) {
        this.pool.setMaxTotal(maxTotal);
    }

    public void setMaxWait(long maxWait) {
        this.pool.setMaxWait(maxWait);
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.pool.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
    }

    public void setMinIdle(int poolSize) {
        this.pool.setMinIdle(poolSize);
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.pool.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.pool.setTestOnBorrow(testOnBorrow);
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.pool.setTestOnReturn(testOnReturn);
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.pool.setTestWhileIdle(testWhileIdle);
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.pool.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
    }

    public void setWhenExhaustedAction(byte whenExhaustedAction) {
        this.pool.setWhenExhaustedAction(whenExhaustedAction);
    }
}

