/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.adapter;

import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.portlet.PortletRequest;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.RRule;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.adapter.AbstractCalendarAdapter;
import org.jasig.portlet.calendar.adapter.CalendarEventSet;
import org.jasig.portlet.calendar.adapter.CalendarException;
import org.jasig.portlet.calendar.adapter.CalendarLinkException;
import org.jasig.portlet.calendar.adapter.ICalendarAdapter;
import org.jasig.portlet.calendar.caching.DefaultCacheKeyGeneratorImpl;
import org.jasig.portlet.calendar.caching.ICacheKeyGenerator;
import org.jasig.portlet.calendar.credentials.DefaultCredentialsExtractorImpl;
import org.jasig.portlet.calendar.credentials.ICredentialsExtractor;
import org.jasig.portlet.calendar.url.DefaultUrlCreatorImpl;
import org.jasig.portlet.calendar.url.IUrlCreator;
import org.joda.time.Interval;
import org.osaf.caldav4j.CalDAVCollection;
import org.osaf.caldav4j.exceptions.CalDAV4JException;
import org.osaf.caldav4j.methods.CalDAV4JMethodFactory;
import org.osaf.caldav4j.methods.HttpClient;

public class CalDavCalendarAdapter
extends AbstractCalendarAdapter
implements ICalendarAdapter {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Cache cache;
    private IUrlCreator urlCreator = new DefaultUrlCreatorImpl();
    private ICredentialsExtractor credentialsExtractor = new DefaultCredentialsExtractorImpl();
    private ICacheKeyGenerator cacheKeyGenerator = new DefaultCacheKeyGeneratorImpl();
    private String cacheKeyPrefix = "default";

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setUrlCreator(IUrlCreator urlCreator) {
        this.urlCreator = urlCreator;
    }

    public void setCredentialsExtractor(ICredentialsExtractor credentialsExtractor) {
        this.credentialsExtractor = credentialsExtractor;
    }

    public void setCacheKeyGenerator(ICacheKeyGenerator cacheKeyGenerator) {
        this.cacheKeyGenerator = cacheKeyGenerator;
    }

    public void setCacheKeyPrefix(String cacheKeyPrefix) {
        this.cacheKeyPrefix = cacheKeyPrefix;
    }

    public CalendarEventSet getEvents(CalendarConfiguration calendarConfiguration, Interval interval, PortletRequest request) throws CalendarException {
        CalendarEventSet eventSet;
        String key;
        Element cachedElement;
        HashSet events = new HashSet();
        String url = this.urlCreator.constructUrl(calendarConfiguration, interval, request);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("generated url: " + url));
        }
        if ((cachedElement = this.cache.get((Serializable)((Object)(key = this.cacheKeyGenerator.getKey(calendarConfiguration, interval, request, this.cacheKeyPrefix.concat(".").concat(url)))))) == null) {
            Credentials credentials = this.credentialsExtractor.getCredentials(request);
            Calendar calendar = this.retrieveCalendar(url, interval, credentials);
            events.addAll(this.convertCalendarToEvents(calendar, interval));
            this.log.debug((Object)("contentProcessor found " + events.size() + " events"));
            eventSet = this.insertCalendarEventSetIntoCache(this.cache, key, events);
        } else {
            eventSet = (CalendarEventSet)cachedElement.getValue();
        }
        return eventSet;
    }

    public String getLink(CalendarConfiguration calendar, Interval interval, PortletRequest request) throws CalendarLinkException {
        throw new CalendarLinkException("This calendar has no link");
    }

    protected final Calendar retrieveCalendar(String url, Interval interval, Credentials credentials) {
        try {
            URL hostUrl = new URL(url);
            int port = hostUrl.getPort();
            if (port == -1) {
                port = hostUrl.getDefaultPort();
            }
            HttpClient httpClient = new HttpClient();
            httpClient.getHostConfiguration().setHost(hostUrl.getHost(), port, Protocol.getProtocol((String)hostUrl.getProtocol()));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("connecting to calDAV host " + httpClient.getHostConfiguration().getHost()));
            }
            if (credentials != null) {
                httpClient.getState().setCredentials(AuthScope.ANY, credentials);
                httpClient.getParams().setAuthenticationPreemptive(true);
            }
            String calendarPath = hostUrl.getPath();
            CalDAVCollection calDAVCollection = new CalDAVCollection(calendarPath, httpClient.getHostConfiguration(), new CalDAV4JMethodFactory(), "-//OSAF//NONSGML CalDAV4j Client//EN");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)calDAVCollection.getCalendarCollectionRoot());
            }
            Calendar cal = calDAVCollection.getCalendar(httpClient, "");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)cal);
            }
            return cal;
        }
        catch (CalDAV4JException e) {
            this.log.error((Object)"CalDAV exception: ", (Throwable)e);
            throw new CalendarException((Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CalendarException("Unknown exception while retrieving calendar", (Throwable)e);
        }
    }

    protected final Set<VEvent> convertCalendarToEvents(Calendar calendar, Interval interval) throws CalendarException {
        Period period = new Period(new DateTime(interval.getStartMillis()), new DateTime(interval.getEndMillis()));
        HashSet<VEvent> events = new HashSet<VEvent>();
        if (calendar == null) {
            this.log.info((Object)"calendar empty, returning empty set");
            return Collections.emptySet();
        }
        for (Component component : calendar.getComponents()) {
            if (!component.getName().equals("VEVENT")) continue;
            VEvent event = (VEvent)component;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("processing event " + event.getSummary().getValue()));
            }
            PeriodList periods = event.calculateRecurrenceSet(period);
            for (Period eventper : periods) {
                PropertyList props = event.getProperties();
                PropertyList newprops = new PropertyList();
                newprops.add((Property)new DtStart((Date)eventper.getStart()));
                newprops.add((Property)new DtEnd((Date)eventper.getEnd()));
                for (Property prop : props) {
                    if (prop instanceof DtStart || prop instanceof DtEnd || prop instanceof Duration || prop instanceof RRule) continue;
                    newprops.add(prop);
                }
                VEvent newevent = new VEvent(newprops);
                events.add(newevent);
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)("added event " + newevent));
            }
        }
        return events;
    }
}

