/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.adapter;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import javax.portlet.PortletRequest;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.util.Calendars;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.adapter.AbstractCalendarAdapter;
import org.jasig.portlet.calendar.adapter.CalendarEventSet;
import org.jasig.portlet.calendar.adapter.CalendarException;
import org.jasig.portlet.calendar.adapter.CalendarLinkException;
import org.jasig.portlet.calendar.adapter.ICalendarAdapter;
import org.jasig.portlet.calendar.caching.DefaultCacheKeyGeneratorImpl;
import org.jasig.portlet.calendar.caching.ICacheKeyGenerator;
import org.jasig.portlet.calendar.processor.ICalendarContentProcessorImpl;
import org.jasig.portlet.calendar.processor.IContentProcessor;
import org.joda.time.Interval;

public class ConfigurableFileCalendarAdapter
extends AbstractCalendarAdapter
implements ICalendarAdapter {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Cache cache;
    private IContentProcessor contentProcessor = new ICalendarContentProcessorImpl();
    private ICacheKeyGenerator cacheKeyGenerator = new DefaultCacheKeyGeneratorImpl();
    private String cacheKeyPrefix = "default";

    public CalendarEventSet getEvents(CalendarConfiguration calendarConfiguration, Interval interval, PortletRequest request) throws CalendarException {
        CalendarEventSet eventSet;
        Set events = Collections.emptySet();
        String fileName = (String)calendarConfiguration.getCalendarDefinition().getParameters().get("file");
        String key = this.cacheKeyGenerator.getKey(calendarConfiguration, interval, request, this.cacheKeyPrefix.concat(".").concat(fileName));
        Element cachedElement = this.cache.get((Serializable)((Object)key));
        if (cachedElement == null) {
            Calendar calendar = this.retrieveCalendar(fileName);
            events = this.contentProcessor.getEvents(interval, (Object)calendar);
            this.log.debug((Object)("contentProcessor found " + events.size() + " events"));
            eventSet = this.insertCalendarEventSetIntoCache(this.cache, key, events);
        } else {
            eventSet = (CalendarEventSet)cachedElement.getValue();
        }
        return eventSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Calendar retrieveCalendar(String fileName) throws CalendarException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Retrieving calendar " + fileName));
        }
        try {
            return Calendars.load((String)fileName);
        }
        catch (ParserException e) {
            this.log.warn((Object)"Error loading iCalendar file feed", (Throwable)e);
            throw new CalendarException("Error fetching iCalendar file feed", (Throwable)e);
        }
        catch (IOException e) {
            this.log.warn((Object)"Error loading iCalendar file feed", (Throwable)e);
            throw new CalendarException("Error loading iCalendar feed", (Throwable)e);
        }
    }

    public String getLink(CalendarConfiguration calendar, Interval interval, PortletRequest request) {
        throw new CalendarLinkException("This calendar has no link");
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setContentProcessor(IContentProcessor contentProcessor) {
        this.contentProcessor = contentProcessor;
    }

    public void setCacheKeyGenerator(ICacheKeyGenerator cacheKeyGenerator) {
        this.cacheKeyGenerator = cacheKeyGenerator;
    }

    public void setCacheKeyPrefix(String cacheKeyPrefix) {
        this.cacheKeyPrefix = cacheKeyPrefix;
    }
}

