/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.io;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.danann.cernunnos.EntityConfig;
import org.danann.cernunnos.Formula;
import org.danann.cernunnos.Phrase;
import org.danann.cernunnos.Reagent;
import org.danann.cernunnos.ReagentType;
import org.danann.cernunnos.SimpleFormula;
import org.danann.cernunnos.SimpleReagent;
import org.danann.cernunnos.TaskRequest;
import org.danann.cernunnos.TaskResponse;

public class SafeFileNamePhrase
implements Phrase {
    private static final Pattern[] WINDOWS_INVALID_PATTERNS = new Pattern[]{Pattern.compile("AUX"), Pattern.compile("CLOCK\\$"), Pattern.compile("COM\\d*"), Pattern.compile("CON"), Pattern.compile("LPT\\d*"), Pattern.compile("NUL"), Pattern.compile("PRN")};
    private static final Map<Pattern, String> REPLACEMENT_PAIRS;
    public static final Reagent HUMAN_FILE_NAME;
    private Phrase humanFileNamePhrase;

    public void init(EntityConfig config) {
        this.humanFileNamePhrase = (Phrase)config.getValue(HUMAN_FILE_NAME);
    }

    public Formula getFormula() {
        return new SimpleFormula(SafeFileNamePhrase.class, new Reagent[]{HUMAN_FILE_NAME});
    }

    public Object evaluate(TaskRequest req, TaskResponse res) {
        String humanFileName = (String)this.humanFileNamePhrase.evaluate(req, res);
        return this.getSafeFileName(humanFileName);
    }

    protected String getSafeFileName(String name) {
        for (Map.Entry<Pattern, String> pair : REPLACEMENT_PAIRS.entrySet()) {
            Pattern pattern = pair.getKey();
            Matcher matcher = pattern.matcher(name);
            name = matcher.replaceAll(pair.getValue());
        }
        String upperCaseName = name.toUpperCase();
        for (Pattern pattern : WINDOWS_INVALID_PATTERNS) {
            if (!pattern.matcher(upperCaseName).matches()) continue;
            name = "uP-" + name;
            break;
        }
        return name;
    }

    static {
        LinkedHashMap<Pattern, String> pairs = new LinkedHashMap<Pattern, String>();
        pairs.put(Pattern.compile("/|\\\\"), ".");
        pairs.put(Pattern.compile("[~`@\\|\\s#$\\*]"), "_");
        REPLACEMENT_PAIRS = Collections.unmodifiableMap(pairs);
        HUMAN_FILE_NAME = new SimpleReagent("HUMAN_FILE_NAME", "descendant-or-self::text()", ReagentType.PHRASE, String.class, "Human readable version of the file name to make safe");
    }
}

