/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.portlet.filter;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.PortletFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import org.springframework.context.ApplicationContext;
import org.springframework.portlet.filter.GenericPortletFilterBean;
import org.springframework.web.portlet.context.PortletApplicationContextUtils;

public class DelegatingPortletFilterProxy
extends GenericPortletFilterBean
implements ActionFilter,
EventFilter,
RenderFilter,
ResourceFilter {
    private String targetBeanName;
    private boolean targetFilterLifecycle = false;
    private PortletFilter delegate;
    private ActionFilter actionDelegate;
    private EventFilter eventDelegate;
    private RenderFilter renderDelegate;
    private ResourceFilter resourceDelegate;
    private final ReadWriteLock delegateLock = new ReentrantReadWriteLock();
    private final Lock delegateReadLock = this.delegateLock.readLock();
    private final Lock delegateWriteLock = this.delegateLock.writeLock();

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }

    protected String getTargetBeanName() {
        return this.targetBeanName;
    }

    public void setTargetFilterLifecycle(boolean targetFilterLifecycle) {
        this.targetFilterLifecycle = targetFilterLifecycle;
    }

    protected boolean isTargetFilterLifecycle() {
        return this.targetFilterLifecycle;
    }

    protected void initFilterBean() throws PortletException {
        if (this.targetBeanName == null) {
            this.targetBeanName = this.getFilterName();
        }
        this.initDelegate(false);
    }

    public void doFilter(ResourceRequest request, ResourceResponse response, FilterChain chain) throws IOException, PortletException {
        this.initDelegate(true);
        if (this.resourceDelegate == null) {
            throw new IllegalStateException("The delegate PortletFilter does not implement ResourceFilter but " + this.getFilterName() + " is configured with the RESOURCE_PHASE lifecycle.");
        }
        this.invokeDelegate(this.resourceDelegate, request, response, chain);
    }

    public void doFilter(EventRequest request, EventResponse response, FilterChain chain) throws IOException, PortletException {
        this.initDelegate(true);
        if (this.eventDelegate == null) {
            throw new IllegalStateException("The delegate PortletFilter does not implement EventFilter but " + this.getFilterName() + " is configured with the EVENT_PHASE lifecycle.");
        }
        this.invokeDelegate(this.eventDelegate, request, response, chain);
    }

    public void doFilter(RenderRequest request, RenderResponse response, FilterChain chain) throws IOException, PortletException {
        this.initDelegate(true);
        if (this.renderDelegate == null) {
            throw new IllegalStateException("The delegate PortletFilter does not implement RenderFilter but " + this.getFilterName() + " is configured with the RENDER_PHASE lifecycle.");
        }
        this.invokeDelegate(this.renderDelegate, request, response, chain);
    }

    public void doFilter(ActionRequest request, ActionResponse response, FilterChain chain) throws IOException, PortletException {
        this.initDelegate(true);
        if (this.actionDelegate == null) {
            throw new IllegalStateException("The delegate PortletFilter does not implement ActionFilter but " + this.getFilterName() + " is configured with the ACTION_PHASE lifecycle.");
        }
        this.invokeDelegate(this.actionDelegate, request, response, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        PortletFilter delegateToUse = null;
        this.delegateReadLock.lock();
        try {
            delegateToUse = this.delegate;
        }
        finally {
            this.delegateReadLock.unlock();
        }
        if (delegateToUse != null) {
            this.destroyDelegate(delegateToUse);
        }
    }

    protected ApplicationContext findWebApplicationContext() {
        return PortletApplicationContextUtils.getWebApplicationContext((PortletContext)this.getPortletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDelegate(boolean require) throws PortletException {
        ApplicationContext wac = this.findWebApplicationContext();
        PortletFilter delegate = null;
        this.delegateReadLock.lock();
        try {
            delegate = this.delegate;
        }
        finally {
            this.delegateReadLock.unlock();
        }
        if (delegate != null) {
            return;
        }
        this.delegateWriteLock.lock();
        try {
            if (this.delegate != null) {
                return;
            }
            if (wac == null) {
                if (require) {
                    throw new IllegalStateException("No ApplicationContext found: no ContextLoaderListener registered?");
                }
                return;
            }
            delegate = (PortletFilter)wac.getBean(this.getTargetBeanName(), PortletFilter.class);
            if (this.isTargetFilterLifecycle()) {
                delegate.init(this.getFilterConfig());
            }
            this.delegate = delegate;
            if (delegate instanceof ActionFilter) {
                this.actionDelegate = (ActionFilter)delegate;
            }
            if (delegate instanceof EventFilter) {
                this.eventDelegate = (EventFilter)delegate;
            }
            if (delegate instanceof RenderFilter) {
                this.renderDelegate = (RenderFilter)delegate;
            }
            if (delegate instanceof ResourceFilter) {
                this.resourceDelegate = (ResourceFilter)delegate;
            }
        }
        finally {
            this.delegateWriteLock.unlock();
        }
    }

    protected void invokeDelegate(ActionFilter delegate, ActionRequest request, ActionResponse response, FilterChain filterChain) throws PortletException, IOException {
        delegate.doFilter(request, response, filterChain);
    }

    protected void invokeDelegate(EventFilter delegate, EventRequest request, EventResponse response, FilterChain filterChain) throws PortletException, IOException {
        delegate.doFilter(request, response, filterChain);
    }

    protected void invokeDelegate(RenderFilter delegate, RenderRequest request, RenderResponse response, FilterChain filterChain) throws PortletException, IOException {
        delegate.doFilter(request, response, filterChain);
    }

    protected void invokeDelegate(ResourceFilter delegate, ResourceRequest request, ResourceResponse response, FilterChain filterChain) throws PortletException, IOException {
        delegate.doFilter(request, response, filterChain);
    }

    protected void destroyDelegate(PortletFilter delegate) {
        if (this.isTargetFilterLifecycle()) {
            delegate.destroy();
        }
    }
}

