/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.portlet.singlefeed;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.Preference;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"EDIT"})
public class EditSingleFeedPreferencesController
implements InitializingBean {
    private List<Integer> optionsMaxStories;
    private Map<String, String> optionsViewTypes;
    protected final Log log = LogFactory.getLog(this.getClass());

    public void afterPropertiesSet() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("flyout", "a list with flyouts");
        m.put("titleAndAbstract", "a list of titles with summaries");
        m.put("title", "a list of titles only");
        this.optionsViewTypes = Collections.unmodifiableMap(m);
        this.optionsMaxStories = Arrays.asList(5, 10, 15, 20);
    }

    @RenderMapping
    protected ModelAndView showForm(RenderRequest request, RenderResponse response) throws Exception {
        this.log.trace((Object)"handleRenderRequestInternal");
        PortletPreferences preferences = request.getPreferences();
        HashMap<String, Preference> model = new HashMap<String, Preference>();
        this.log.debug((Object)("name preference readOnly: " + preferences.isReadOnly("name")));
        Preference name = new Preference();
        name.setValue(preferences.getValue("name", ""));
        name.setReadOnly(preferences.isReadOnly("name"));
        model.put("name", name);
        this.log.debug((Object)("url preference readOnly: " + preferences.isReadOnly("url")));
        Preference url = new Preference();
        url.setValue(preferences.getValue("url", ""));
        url.setReadOnly(preferences.isReadOnly("url"));
        model.put("url", url);
        this.log.debug((Object)("className preference readOnly: " + preferences.isReadOnly("className")));
        Preference className = new Preference();
        className.setValue(preferences.getValue("className", ""));
        className.setReadOnly(preferences.isReadOnly("className"));
        model.put("className", className);
        Preference max = new Preference();
        max.setOptions((Object)this.optionsMaxStories);
        max.setValue(preferences.getValue("maxStories", ""));
        max.setReadOnly(preferences.isReadOnly("maxStories"));
        model.put("max", max);
        Preference view = new Preference();
        view.setOptions((Object)this.optionsViewTypes);
        view.setValue(preferences.getValue("summaryView", ""));
        view.setReadOnly(preferences.isReadOnly("summaryView"));
        model.put("view", view);
        Preference newWindow = new Preference();
        newWindow.setValue(preferences.getValue("newWindow", Boolean.TRUE.toString()));
        newWindow.setReadOnly(preferences.isReadOnly("newWindow"));
        model.put("newWindow", newWindow);
        return new ModelAndView("editSingleFeed", model);
    }

    @ResourceMapping
    public String savePreference(ResourceRequest request, ResourceResponse response, Model model) throws Exception {
        try {
            String prefName = request.getParameter("prefName");
            String prefValue = request.getParameter("prefValue");
            this.log.debug((Object)("Storing: " + prefName + " : " + prefValue));
            PortletPreferences prefs = request.getPreferences();
            prefs.setValue(prefName, prefValue);
            prefs.store();
            JSONObject json = new JSONObject();
            json.put((Object)"status", (Object)"success");
            model.addAttribute("json", (Object)json);
            return "json";
        }
        catch (Exception e) {
            this.log.error((Object)"There was an error saving the preferences.", (Throwable)e);
            throw e;
        }
    }
}

