/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.filtering;

import edu.wisc.my.webproxy.beans.config.GeneralConfigImpl;
import edu.wisc.my.webproxy.beans.filtering.InclExclUrlFilter;
import edu.wisc.my.webproxy.portlet.WebproxyConstants;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.XMLReader;

public class FuncNameUrlFilter
extends InclExclUrlFilter {
    private static final Log log = LogFactory.getLog(FuncNameUrlFilter.class);
    private static final String IDEMPOTENT_UP_FILE = "tag.idempotent.render.userLayoutRootNode.uP";
    private static final String PORTLET_ACTION = "?uP_portlet_action=true";
    private static final String FNAME_PREFIX = "&uP_fname=";
    private static final String WINDOW_STATE_PREFIX = "&uP_window_state=";
    private static final String SEPERATOR_AND = "&";
    private static final String SEPERATOR_EQL = "=";
    private String[] urlStateList = null;
    private String encodedFuncName = null;

    public FuncNameUrlFilter() {
    }

    public FuncNameUrlFilter(XMLReader parent) {
        super(parent);
    }

    protected String doUrlRewite(String orignialUrl, int matchIndex, boolean passThrough) {
        if (this.encodedFuncName == null) {
            return orignialUrl;
        }
        StringBuffer buff = new StringBuffer(512);
        buff.append(IDEMPOTENT_UP_FILE);
        buff.append(PORTLET_ACTION);
        buff.append(FNAME_PREFIX);
        buff.append(this.encodedFuncName);
        if (matchIndex >= 0 && this.urlStateList[matchIndex] != null && this.urlStateList[matchIndex].trim().length() > 0) {
            buff.append(WINDOW_STATE_PREFIX);
            buff.append(this.urlStateList[matchIndex]);
        }
        buff.append(SEPERATOR_AND);
        buff.append(WebproxyConstants.BASE_URL);
        buff.append(SEPERATOR_EQL);
        buff.append(this.encodeString(orignialUrl));
        String fNameUrl = orignialUrl.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Re-Wrote '" + orignialUrl + "' to '" + fNameUrl + "'"));
        }
        return buff.toString();
    }

    private String encodeString(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Error URL encoding string '" + text + "' to 'UTF-8'"), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setRenderData(RenderRequest request, RenderResponse response) {
        PortletPreferences pp = request.getPreferences();
        String[] urlRegExList = pp.getValues(GeneralConfigImpl.FNAME_URL_REWRITE_MASKS, null);
        this.setUrlRegExList(urlRegExList);
        String listType = pp.getValue(GeneralConfigImpl.FNAME_URL_LIST_TYPE, null);
        this.setListType(listType);
        this.urlStateList = pp.getValues(GeneralConfigImpl.FNAME_URL_REWRITE_STATES, null);
        this.encodedFuncName = pp.getValue(GeneralConfigImpl.FNAME_TARGET, null);
        if (this.encodedFuncName != null) {
            this.encodedFuncName = this.encodeString(this.encodedFuncName);
        }
        super.setRenderData(request, response);
    }

    public void clearData() {
        this.urlStateList = null;
        this.encodedFuncName = null;
        this.setListType(null);
        this.setListType(null);
        super.clearData();
    }

    public String getName() {
        return "Functional Name URL Filter";
    }

    public void setActionData(ActionRequest request, ActionResponse response) {
        throw new IllegalStateException("FuncNameUrlFilter is invalid to use during an action");
    }
}

