/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.http;

import edu.wisc.my.webproxy.beans.http.ICookie;
import edu.wisc.my.webproxy.beans.http.IWebProxyState;
import edu.wisc.my.webproxy.beans.http.PersistedCookieImpl;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="WP_STATE")
@GenericGenerator(name="WP_STATE_ID_GEN", strategy="native", parameters={@Parameter(name="sequence", value="WP_STATE_ID_SEQ"), @Parameter(name="table", value="WP_JPA_UNIQUE_KEY"), @Parameter(name="column", value="NEXT_WP_STATE_ID_HI")})
public class WebProxyStateImpl
implements IWebProxyState {
    @Id
    @GeneratedValue(generator="WP_STATE_ID_GEN")
    @Column(name="STATE_ID")
    private final long stateId;
    @Column(name="STATE_KEY", unique=true, updatable=false, length=500)
    @Index(name="STATE_KEY_IDX")
    private String stateKey;
    @OneToMany(cascade={CascadeType.ALL}, targetEntity=PersistedCookieImpl.class, fetch=FetchType.EAGER)
    @JoinColumn(name="STATE_ID")
    @IndexColumn(name="COOKIE_ORDER")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    private List<ICookie> cookies = new ArrayList();

    public WebProxyStateImpl() {
        this.stateId = -1L;
    }

    public WebProxyStateImpl(String stateKey) {
        this.stateId = -1L;
        this.stateKey = stateKey;
    }

    public String getStateKey() {
        return this.stateKey;
    }

    public List<ICookie> getCookies() {
        return this.cookies;
    }

    public void setCookies(List<ICookie> cookies) {
        if (this.cookies == cookies) {
            return;
        }
        this.cookies.clear();
        for (ICookie cookie : cookies) {
            this.cookies.add(cookie);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.stateKey == null ? 0 : this.stateKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebProxyStateImpl other = (WebProxyStateImpl)obj;
        return !(this.stateKey == null ? other.stateKey != null : !this.stateKey.equals(other.stateKey));
    }

    public String toString() {
        return "WebProxyStateImpl [stateId=" + this.stateId + ", stateKey=" + this.stateKey + ", cookies=" + this.cookies + "]";
    }
}

