/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.interceptors;

import edu.wisc.my.webproxy.beans.http.Request;
import edu.wisc.my.webproxy.beans.interceptors.UserInfoParameterizingPreInterceptor;
import java.io.UnsupportedEncodingException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class UserInfoUrlParameterizingPreInterceptor
extends UserInfoParameterizingPreInterceptor {
    public void intercept(RenderRequest req, RenderResponse res, Request httpReq) {
        this.updateUri((PortletRequest)req, httpReq);
    }

    public void intercept(ActionRequest req, ActionResponse res, Request httpReq) {
        this.updateUri((PortletRequest)req, httpReq);
    }

    private void updateUri(PortletRequest req, Request httpResp) {
        String uri = httpResp.getUrl();
        this.log.debug((Object)("Supplied URL:  " + uri));
        try {
            String newUri = this.injectUriParameters(req, uri);
            this.log.debug((Object)("URL after processing parameters:  " + newUri));
            httpResp.setUrl(newUri);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String injectUriParameters(PortletRequest req, String uri) throws UnsupportedEncodingException {
        String requestUri = null;
        String queryString = "";
        int queryStringBegin = uri.indexOf("?");
        if (queryStringBegin == -1) {
            requestUri = uri;
        } else {
            requestUri = uri.substring(0, queryStringBegin);
            queryString = uri.substring(queryStringBegin);
        }
        requestUri = this.resolveTokens(req, requestUri, UserInfoParameterizingPreInterceptor.Strategy.REPLACE);
        queryString = this.resolveTokens(req, queryString, UserInfoParameterizingPreInterceptor.Strategy.EXPAND);
        return requestUri + queryString;
    }
}

