/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.model.xml;

import java.text.DateFormat;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;

public abstract class CourseMeetingWrapper {
    private static final DateFormat DATE_FORMAT = DateFormat.getTimeInstance(3);

    public abstract XMLGregorianCalendar getStartTime();

    public abstract XMLGregorianCalendar getEndTime();

    public abstract List<String> getDayIds();

    public String getFormattedMeetingTime() {
        StringBuilder rslt = new StringBuilder();
        XMLGregorianCalendar startTime = this.getStartTime();
        XMLGregorianCalendar endTime = this.getEndTime();
        if (startTime != null) {
            rslt.append(DATE_FORMAT.format(startTime.toGregorianCalendar().getTime()));
            if (endTime != null) {
                rslt.append(" - ").append(DATE_FORMAT.format(endTime.toGregorianCalendar().getTime()));
            }
        }
        return rslt.toString();
    }

    public String getFormattedMeetingDays() {
        StringBuilder rslt = new StringBuilder();
        List<String> days = this.getDayIds();
        if (days != null && days.size() != 0) {
            for (String day : days) {
                rslt.append(day).append(", ");
            }
            rslt.setLength(rslt.length() - 2);
        }
        return rslt.toString();
    }
}

