/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview;

import java.math.BigDecimal;

public class EmailQuota {
    public static final String QUOTA_UNIT_MB = "MB";
    public static final String QUOTA_UNIT_GB = "GB";
    public static final long QUOTA_COEF_MB = 1024L;
    public static final long QUOTA_COEF_GB = 0x100000L;
    private long usage;
    private long limit;

    public EmailQuota() {
        this(0L, 0L);
    }

    public EmailQuota(long limit, long usage) {
        this.limit = limit;
        this.usage = usage;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public long getUsage() {
        return this.usage;
    }

    public void setUsage(long usage) {
        this.usage = usage;
    }

    public String getLimitAsString() {
        return this.getValueAsString(this.limit);
    }

    public String getUsageAsString() {
        return this.getValueAsString(this.usage);
    }

    public String getUsageAsPercentage() {
        return new BigDecimal(String.valueOf((double)this.usage / (double)this.limit)).setScale(2, 1).toString().concat("%");
    }

    private String getValueAsString(long value) {
        String unit = QUOTA_UNIT_MB;
        long coef = 1024L;
        if (value > 999999L) {
            unit = QUOTA_UNIT_GB;
            coef = 0x100000L;
        }
        return new BigDecimal(String.valueOf((double)value / (double)coef)).setScale(2, 1).toString().concat(unit);
    }
}

