/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.controller;

import java.util.HashMap;
import javax.portlet.PortletPreferences;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class AjaxUpdatePageSizeController {
    private static final String STATUS_KEY = "success";
    private final Log log = LogFactory.getLog(this.getClass());

    @ResourceMapping(value="updatePageSize")
    public ModelAndView updatePageSize(ResourceRequest req, ResourceResponse res, @RequestParam(value="newPageSize") int newPageSize) throws Exception {
        PortletPreferences prefs = req.getPreferences();
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (!prefs.isReadOnly("pageSize")) {
            prefs.setValue("pageSize", Integer.toString(newPageSize));
            prefs.store();
            model.put(STATUS_KEY, true);
        } else {
            if (this.log.isDebugEnabled()) {
                String msg = "Ignoring change to pageSize for the following user because the preference is read only:  " + req.getRemoteUser();
                this.log.debug((Object)msg);
            }
            res.setProperty("portlet.http-status-code", Integer.toString(401));
            model.put("error", "Not authorized");
        }
        return new ModelAndView("json", model);
    }
}

