/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.service.auth.pp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Authenticator;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.dao.MailPreferences;
import org.jasig.portlet.emailpreview.service.ConfigurationParameter;
import org.jasig.portlet.emailpreview.service.auth.BaseCredentialsAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.SimplePasswordAuthenticator;

public class PortletPreferencesCredentialsAuthenticationService
extends BaseCredentialsAuthenticationService {
    public static final String KEY = "portletPreferences";
    private static final String ACCOUNT_NAME_ATTRIBUTE_KEY = "PortletPreferencesCredentialsAuthenticationService.ACCOUNT_NAME_ATTRIBUTE";
    private static final String ACCOUNT_NAME_ATTRIBUTE_LABEL = "If specified, use this user attribute as the mail account name (users won't be able to edit it)";
    private static final ConfigurationParameter ACCOUNT_NAME_ATTRIBUTE = new ConfigurationParameter("PortletPreferencesCredentialsAuthenticationService.ACCOUNT_NAME_ATTRIBUTE", "If specified, use this user attribute as the mail account name (users won't be able to edit it)", null, false);

    public PortletPreferencesCredentialsAuthenticationService() {
        ArrayList<ConfigurationParameter> params = new ArrayList<ConfigurationParameter>();
        ConfigurationParameter usernameParam = new ConfigurationParameter();
        usernameParam.setKey(MailPreferences.MAIL_ACCOUNT.getKey());
        usernameParam.setLabel("Mail account name");
        usernameParam.setEncryptionRequired(true);
        params.add(usernameParam);
        ConfigurationParameter passwordParam = new ConfigurationParameter();
        passwordParam.setKey(MailPreferences.PASSWORD.getKey());
        passwordParam.setLabel("Password");
        passwordParam.setEncryptionRequired(true);
        params.add(passwordParam);
        this.setUserParameters(Collections.unmodifiableList(params));
        this.setAdminParameters(Collections.singletonList(ACCOUNT_NAME_ATTRIBUTE));
        HashMap<String, ConfigurationParameter> m = new HashMap<String, ConfigurationParameter>();
        for (ConfigurationParameter param : this.userParameters) {
            m.put(param.getKey(), param);
        }
        this.setConfigParams(Collections.unmodifiableMap(m));
    }

    public boolean isConfigured(PortletRequest req, MailStoreConfiguration config) {
        String mailAccount = this.getMailAccountName(req, config);
        String password = (String)config.getAdditionalProperties().get(MailPreferences.PASSWORD.getKey());
        return mailAccount != null && password != null;
    }

    public Authenticator getAuthenticator(PortletRequest request, MailStoreConfiguration config) {
        String password = (String)config.getAdditionalProperties().get(MailPreferences.PASSWORD.getKey());
        return new SimplePasswordAuthenticator(this.getMailAccountName(request, config), password);
    }

    public Credentials getCredentials(PortletRequest req, MailStoreConfiguration config) {
        String ntlmDomain = config.getExchangeDomain();
        String password = (String)config.getAdditionalProperties().get(MailPreferences.PASSWORD.getKey());
        if (StringUtils.isNotBlank((String)ntlmDomain)) {
            String username = this.getMailAccountName(req, config);
            return this.createNTCredentials(ntlmDomain, username, password);
        }
        return new UsernamePasswordCredentials(this.getMailAccountName(req, config), password);
    }

    public String getMailAccountName(PortletRequest req, MailStoreConfiguration config) {
        String accountName = null;
        String accountNameAttribute = (String)config.getAdditionalProperties().get(ACCOUNT_NAME_ATTRIBUTE_KEY);
        if (StringUtils.isNotBlank((String)accountNameAttribute)) {
            Map userInfo = (Map)req.getAttribute("javax.portlet.userinfo");
            accountName = (String)userInfo.get(accountNameAttribute);
        } else {
            accountName = (String)config.getAdditionalProperties().get(MailPreferences.MAIL_ACCOUNT.getKey());
        }
        return this.createMailAccountName(accountName, config);
    }

    public String getKey() {
        return KEY;
    }
}

