/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletRequest;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;

public final class EmailAccountUtils {
    private static final Pattern DOMAIN_PATTERN = Pattern.compile("\\.([a-zA-Z0-9]+\\.[a-zA-Z0-9]+)\\z");
    private static final Pattern IP_ADDRESS_PATTERN = Pattern.compile("\\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b");

    public static String determineUserEmailAddress(PortletRequest req, MailStoreConfiguration config, IAuthenticationService authService) {
        String emailAddress = null;
        String mailAccount = authService.getMailAccountName(req, config);
        String nameSuffix = config.getUsernameSuffix();
        String serverName = config.getHost();
        if (mailAccount.contains("@")) {
            emailAddress = mailAccount;
        } else if (nameSuffix != null && nameSuffix.length() != 0) {
            emailAddress = mailAccount + nameSuffix;
        } else if (IP_ADDRESS_PATTERN.matcher(serverName).find()) {
            emailAddress = mailAccount;
        } else {
            emailAddress = mailAccount;
            Matcher m = DOMAIN_PATTERN.matcher(serverName);
            if (m.find()) {
                emailAddress = emailAddress + "@" + m.group(1);
            }
        }
        return emailAddress;
    }
}

