/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.dao.exchange;

import javax.mail.Authenticator;
import javax.portlet.PortletRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.service.ICredentialsProvider;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.portlet.context.PortletRequestAttributes;

@Component
public class MailCredentialsProvider
implements CredentialsProvider,
ICredentialsProvider {
    private static final String EXCHANGE_CREDENTIALS_ATTRIBUTE = "exchangeCredentials";
    private static final String JAVAMAIL_CREDENTIALS_ATTRIBUTE = "javamailCredentials";

    public void clear() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            requestAttributes.setAttribute(EXCHANGE_CREDENTIALS_ATTRIBUTE, null, 0);
            requestAttributes.setAttribute(JAVAMAIL_CREDENTIALS_ATTRIBUTE, null, 0);
        }
    }

    public Credentials getCredentials() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        Credentials credentials = (Credentials)requestAttributes.getAttribute(EXCHANGE_CREDENTIALS_ATTRIBUTE, 0);
        return credentials;
    }

    public Credentials getCredentials(AuthScope authscope) {
        return this.getCredentials();
    }

    public void setCredentials(AuthScope authscope, Credentials credentials) {
        throw new UnsupportedOperationException("Unsupported method - use initialize");
    }

    public Authenticator getAuthenticator() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        Authenticator authenticator = (Authenticator)requestAttributes.getAttribute(JAVAMAIL_CREDENTIALS_ATTRIBUTE, 0);
        return authenticator;
    }

    public void initialize(PortletRequest request, MailStoreConfiguration config, IAuthenticationService authService) {
        Credentials credentials = authService.getCredentials(request, config);
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            requestAttributes = new PortletRequestAttributes(request);
            RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
        }
        requestAttributes.setAttribute(EXCHANGE_CREDENTIALS_ATTRIBUTE, (Object)credentials, 0);
        Authenticator authenticator = authService.getAuthenticator(request, config);
        requestAttributes.setAttribute(JAVAMAIL_CREDENTIALS_ATTRIBUTE, (Object)authenticator, 0);
    }

    public String getUsername() {
        return this.getCredentials(null).getUserPrincipal().getName();
    }
}

