/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.service.auth.cas;

import java.util.Map;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.jasig.portlet.emailpreview.service.auth.cas.ICASProxyTicketService;

public class CASProxyTicketServiceUserInfoImpl
implements ICASProxyTicketService {
    protected final Log log = LogFactory.getLog(this.getClass());
    private String serviceUrl;
    private TicketValidator ticketValidator;

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setTicketValidator(TicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    public Assertion getProxyTicket(PortletRequest request) {
        Map userinfo = (Map)request.getAttribute("javax.portlet.userinfo");
        String ticket = (String)userinfo.get("casProxyTicket");
        if (ticket == null) {
            this.log.debug((Object)"No CAS ticket found in the UserInfo map");
            return null;
        }
        this.log.debug((Object)("serviceURL: " + this.serviceUrl + ", ticket: " + ticket));
        try {
            Assertion assertion = this.ticketValidator.validate(ticket, this.serviceUrl);
            return assertion;
        }
        catch (TicketValidationException e) {
            this.log.warn((Object)"Failed to validate proxy ticket", (Throwable)e);
            return null;
        }
    }

    public String getCasServiceToken(Assertion assertion, String target) {
        String proxyTicket = assertion.getPrincipal().getProxyTicketFor(target);
        if (proxyTicket == null) {
            this.log.error((Object)("Failed to retrieve proxy ticket for assertion [" + assertion.toString() + "].  Is the PGT still valid?"));
            return null;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("returning from getCasServiceToken(), returning proxy ticket [" + proxyTicket + "]"));
        }
        return proxyTicket;
    }
}

