/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.service.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.jasig.portlet.widget.service.xml.AbstractXmlAlertService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public final class ClasspathXmlAlertService
extends AbstractXmlAlertService
implements ApplicationContextAware {
    private static final String LOCATION_PREFERENCE = "ClasspathXmlAlertService.feedLocation";
    private ApplicationContext ctx;
    private final Log log = LogFactory.getLog(this.getClass());

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.ctx = ctx;
    }

    protected Document loadDocument(PortletRequest req) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"Updating feed from external source");
        }
        Document rslt = null;
        String loc = req.getPreferences().getValue(LOCATION_PREFERENCE, null);
        InputStream inpt = null;
        try {
            Resource r = this.ctx.getResource(loc);
            inpt = r.getInputStream();
            rslt = new SAXReader().read(inpt);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inpt != null) {
                try {
                    inpt.close();
                }
                catch (IOException ioe) {
                    this.log.warn((Object)ioe.getMessage(), (Throwable)ioe);
                }
            }
        }
        return rslt;
    }
}

