/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.mvc;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"CONFIG"})
public class EditGoogleApiKeyController {
    public static final String GOOGLE_API_KEY_PREF_NAME = "googleApiKey";

    @RenderMapping
    public String getFormView() {
        return "editGoogleApiKey";
    }

    @ActionMapping(params={"action=updateKey"})
    public void updateKey(ActionRequest request, ActionResponse response, @RequestParam(value="googleApiKey") String key) throws PortletModeException, ReadOnlyException, ValidatorException, IOException {
        PortletPreferences prefs = request.getPreferences();
        prefs.setValue(GOOGLE_API_KEY_PREF_NAME, key);
        prefs.store();
        response.setPortletMode(PortletMode.VIEW);
    }

    @ModelAttribute(value="googleApiKey")
    public String getKey(PortletRequest request) {
        PortletPreferences prefs = request.getPreferences();
        return prefs.getValue(GOOGLE_API_KEY_PREF_NAME, null);
    }
}

