/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice;

import java.io.IOException;
import java.util.Date;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

public class JsonDateDeserializer
extends JsonDeserializer<Date> {
    private static final String TIME_FILDNAME = "time";

    public Date deserialize(JsonParser parser, DeserializationContext ctx) throws JsonParseException, IOException {
        String time = null;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldname = parser.getCurrentName();
            if (!TIME_FILDNAME.equals(fieldname)) continue;
            parser.nextToken();
            time = parser.getText();
        }
        if (time == null) {
            String msg = "Invalid date input at location:  " + parser.getCurrentLocation();
            throw new IllegalArgumentException(msg);
        }
        long rslt = Long.parseLong(time);
        return new Date(rslt);
    }
}

