/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.jasig.portlet.notice.NotificationAction;

public class JsonNotificationActionDeserializer
extends JsonDeserializer<NotificationAction> {
    private static final String CLAZZ_FILDNAME = "clazz";
    private static final String LABEL_FILDNAME = "label";

    public NotificationAction deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        NotificationAction rslt;
        String clazz = null;
        String label = null;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldname = parser.getCurrentName();
            if (CLAZZ_FILDNAME.equals(fieldname)) {
                parser.nextToken();
                clazz = parser.getText();
                continue;
            }
            if (!LABEL_FILDNAME.equals(fieldname)) continue;
            parser.nextToken();
            label = parser.getText();
        }
        if (clazz == null) {
            String msg = "Unable to deserialize NotificationAction due to missing clazz field";
            throw new IllegalArgumentException("Unable to deserialize NotificationAction due to missing clazz field");
        }
        try {
            rslt = (NotificationAction)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate a NotificationAction of concrete class:  " + clazz);
        }
        if (label != null) {
            rslt.setLabel(label);
        }
        return rslt;
    }
}

