/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Date;

public class JsonDateDeserializer
extends JsonDeserializer<Date> {
    private static final String TIME_FILDNAME = "time";

    public Date deserialize(JsonParser parser, DeserializationContext ctx) throws JsonParseException, IOException {
        String time = null;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldname = parser.getCurrentName();
            if (!TIME_FILDNAME.equals(fieldname)) continue;
            parser.nextToken();
            time = parser.getText();
        }
        if (time == null) {
            String msg = "Invalid date input at location:  " + parser.getCurrentLocation();
            throw new IllegalArgumentException(msg);
        }
        long rslt = Long.parseLong(time);
        return new Date(rslt);
    }
}

