/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.rome;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.notice.NotificationAttribute;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationError;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.service.AbstractNotificationService;
import org.jasig.portlet.notice.service.rome.TimestampNotificationEntry;
import org.jasig.portlet.notice.util.UsernameFinder;
import org.springframework.beans.factory.annotation.Autowired;

public final class RomeNotificationService
extends AbstractNotificationService {
    public static final String URLS_PREFERENCE = "RomeNotificationService.urls";
    private static final Object NO_FURTHER_INFORMATION = "No further information is available.";
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(3);
    private Cache cache;
    @Autowired
    private UsernameFinder usernameFinder;
    private final Log log = LogFactory.getLog(this.getClass());

    @Resource(name="RomeNotificationService.feedCache")
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public void invoke(ActionRequest req, ActionResponse res, boolean refresh) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Performing RomeNotificationService.invoke() for user='" + this.usernameFinder.findUsername((PortletRequest)req) + "' refresh=" + refresh));
        }
        if (refresh) {
            String[] urls;
            PortletPreferences prefs = req.getPreferences();
            for (String item : urls = prefs.getValues(URLS_PREFERENCE, new String[0])) {
                this.cache.remove((Serializable)((Object)item));
            }
        }
    }

    @Override
    public NotificationResponse fetch(ResourceRequest req) {
        String[] urls;
        ArrayList<NotificationCategory> categories = new ArrayList<NotificationCategory>();
        ArrayList<NotificationError> errors = new ArrayList<NotificationError>();
        PortletPreferences prefs = req.getPreferences();
        for (String item : urls = prefs.getValues(URLS_PREFERENCE, new String[0])) {
            NotificationCategory category;
            Element m = this.cache.get((Serializable)((Object)item));
            if (m != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Feed cache HIT for url:  " + item));
                }
                category = (NotificationCategory)m.getObjectValue();
                categories.add(category);
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Feed cache MISS for url:  " + item));
                this.log.debug((Object)("Checking the following feed URL for notifications for user '" + this.usernameFinder.findUsername((PortletRequest)req) + "' -- " + item));
            }
            if ((category = this.fetchFromSource(item)) != null) {
                this.cache.put(new Element((Serializable)((Object)item), (Serializable)category));
                categories.add(category);
                continue;
            }
            NotificationError error = new NotificationError();
            error.setError("Service Unavailable");
            error.setSource(this.getName());
            errors.add(error);
        }
        NotificationResponse rslt = new NotificationResponse();
        rslt.setCategories(categories);
        rslt.setErrors(errors);
        return rslt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotificationCategory fetchFromSource(String url) {
        String msg;
        NotificationCategory rslt = null;
        XmlReader reader = null;
        try {
            URL u = new URL(url);
            reader = new XmlReader(u);
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed feed = input.build((Reader)reader);
            rslt = new NotificationCategory();
            rslt.setTitle(feed.getTitle());
            ArrayList<TimestampNotificationEntry> entries = new ArrayList<TimestampNotificationEntry>();
            List list = feed.getEntries();
            for (SyndEntry y : list) {
                Date updatededDate;
                Date publishedDate;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Processing SyndEntry:  \n" + y.toString()));
                }
                long timestamp = y.getPublishedDate().getTime();
                TimestampNotificationEntry entry = new TimestampNotificationEntry(timestamp);
                entry.setSource(feed.getAuthor());
                entry.setTitle(y.getTitle());
                entry.setUrl(y.getLink());
                StringBuilder body = new StringBuilder();
                SyndContent desc = y.getDescription();
                if (desc != null) {
                    body.append(desc.getValue());
                }
                if (body.length() == 0) {
                    List contents = y.getContents();
                    for (SyndContent c : contents) {
                        body.append(c.getValue());
                    }
                }
                if (body.length() == 0) {
                    body.append(NO_FURTHER_INFORMATION);
                }
                entry.setBody(body.toString());
                ArrayList<NotificationAttribute> attributes = new ArrayList<NotificationAttribute>();
                String author = y.getAuthor();
                if (StringUtils.isNotBlank((String)author)) {
                    attributes.add(new NotificationAttribute("Author", author));
                }
                if ((publishedDate = y.getPublishedDate()) != null) {
                    attributes.add(new NotificationAttribute("Published date", DATE_FORMAT.format(publishedDate)));
                }
                if ((updatededDate = y.getUpdatedDate()) != null) {
                    attributes.add(new NotificationAttribute("Updated date", DATE_FORMAT.format(updatededDate)));
                }
                entry.setAttributes(attributes);
                entries.add(entry);
            }
            Collections.sort(entries);
            Collections.reverse(entries);
            rslt.setEntries(new ArrayList(entries));
        }
        catch (Exception e) {
            msg = "Unable to read the specified feed:  " + url;
            this.log.error((Object)msg, (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    msg = "Unable to close the XmlReader";
                    this.log.error((Object)"Unable to close the XmlReader", (Throwable)ioe);
                }
            }
        }
        return rslt;
    }
}

