/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.attachment.dao.jpa;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.jasig.portlet.attachment.dao.IAttachmentDao;
import org.jasig.portlet.attachment.dao.jpa.BaseJpaDao;
import org.jasig.portlet.attachment.model.Attachment;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JpaAttachmentDao
extends BaseJpaDao
implements IAttachmentDao {
    @Override
    @Transactional
    public Attachment get(long attachmentId) {
        Attachment attachment = (Attachment)this.getEntityManager().find(Attachment.class, (Object)attachmentId);
        return attachment;
    }

    @Override
    @Transactional
    public Attachment get(String guid) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("guid", guid);
        Attachment attachment = this.getResult("Attachment.getByGuid", params);
        return attachment;
    }

    @Override
    @Transactional
    public List<Attachment> find(String creator) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("creator", creator);
        List<Attachment> list = this.getResultList("Attachment.findByCreator", params);
        return list;
    }

    @Override
    @Transactional
    public List<Attachment> find(String creator, String filename) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("creator", creator);
        params.put("filename", filename);
        List<Attachment> list = this.getResultList("Attachment.findByFilename", params);
        return list;
    }

    @Override
    @Transactional
    public List<Attachment> findAll(int offset, int maxresults) {
        List<Attachment> list = this.getResultListPaged("Attachment.findAll", new HashMap<String, String>(), offset, maxresults);
        return list;
    }

    @Override
    @Transactional
    public Attachment save(Attachment attachment) {
        return (Attachment)this.getEntityManager().merge((Object)attachment);
    }

    @Override
    @Transactional
    public void delete(Attachment attachment) {
        this.getEntityManager().remove((Object)attachment);
    }

    @Override
    @Transactional
    public void delete(long attachmentId) {
        Attachment attachment = this.get(attachmentId);
        if (attachment != null) {
            this.delete(attachment);
        }
    }

    private Attachment getResult(String select, Map<String, String> params) {
        try {
            TypedQuery<Attachment> query = this.createQuery(select, params);
            Attachment attachment = (Attachment)query.getSingleResult();
            return attachment;
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    private List<Attachment> getResultList(String select, Map<String, String> params) {
        try {
            TypedQuery<Attachment> query = this.createQuery(select, params);
            List results = query.getResultList();
            return results;
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    private List<Attachment> getResultListPaged(String select, Map<String, String> params, int offset, int maxresults) {
        try {
            TypedQuery<Attachment> query = this.createQuery(select, params);
            query.setFirstResult(offset);
            query.setMaxResults(maxresults);
            List results = query.getResultList();
            return results;
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    private TypedQuery<Attachment> createQuery(String select, Map<String, String> params) {
        TypedQuery query = this.getEntityManager().createNamedQuery(select, Attachment.class);
        for (String key : params.keySet()) {
            query.setParameter(key, (Object)params.get(key));
        }
        return query;
    }
}

