/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.search.mvc;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
@RequestMapping(value={"/gsaSearch"})
public class GsaSearchController {
    private static Log log = LogFactory.getLog(GsaSearchController.class);
    private static final String QUERY_PARAMETER_NAME = "q";
    private static final String SITE_PARAMETER_NAME = "site";
    private static final String NUMBER_LIMIT_PARAMETER_NAME = "num";
    private View view;
    public String googleSearchServlet = "search";
    public String googleBaseUrl;
    public String googleStylesheetName;
    public Map<String, String> googleParameters = new HashMap();

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView searchGsa(HttpServletRequest request) throws HttpException, IOException {
        String query = request.getParameter(QUERY_PARAMETER_NAME);
        String site = request.getParameter(SITE_PARAMETER_NAME);
        String num = request.getParameter(NUMBER_LIMIT_PARAMETER_NAME);
        String url = this.buildGoogleSearchUrl(query, site, num);
        log.debug((Object)("Searching GSA with URL " + url));
        HttpClient client = new HttpClient();
        GetMethod get = new GetMethod(url);
        int rc = client.executeMethod((HttpMethod)get);
        if (rc != 200) {
            log.warn((Object)("HttpStatus for " + url + ":" + rc));
        }
        InputStream is = get.getResponseBodyAsStream();
        return new ModelAndView(this.view, "source", (Object)is);
    }

    protected String buildGoogleSearchUrl(String query, String site, String num) throws UnsupportedEncodingException {
        StringBuffer googleUrl = new StringBuffer();
        googleUrl.append(this.googleBaseUrl);
        googleUrl.append("/");
        googleUrl.append(this.googleSearchServlet);
        this.addParameter(googleUrl, QUERY_PARAMETER_NAME, query, true);
        if (site != null && !site.equals("")) {
            this.addParameter(googleUrl, SITE_PARAMETER_NAME, site, false);
        }
        this.addParameter(googleUrl, NUMBER_LIMIT_PARAMETER_NAME, num, false);
        for (String paramName : this.googleParameters.keySet()) {
            this.addParameter(googleUrl, paramName, (String)this.googleParameters.get(paramName), false);
        }
        return googleUrl.toString();
    }

    protected void addParameter(StringBuffer url, String paramName, String paramValue, boolean firstParam) throws UnsupportedEncodingException {
        if (firstParam) {
            url.append("?");
        } else {
            url.append("&");
        }
        url.append(paramName);
        url.append("=");
        url.append(URLEncoder.encode(paramValue, "UTF-8"));
    }

    public void setView(View view) {
        this.view = view;
    }

    public void setGoogleBaseUrl(String googleBaseUrl) {
        this.googleBaseUrl = googleBaseUrl;
    }

    public void setGoogleStylesheetName(String googleStylesheetName) {
        this.googleStylesheetName = googleStylesheetName;
    }

    @Resource(name="gsaParameters")
    public void setGoogleParameters(Map<String, String> googleParameters) {
        this.googleParameters = googleParameters;
    }
}

