<!--

    Licensed to Jasig under one or more contributor license
    agreements. See the NOTICE file distributed with this work
    for additional information regarding copyright ownership.
    Jasig licenses this file to you under the Apache License,
    Version 2.0 (the "License"); you may not use this file
    except in compliance with the License. You may obtain a
    copy of the License at:

    http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on
    an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied. See the License for the
    specific language governing permissions and limitations
    under the License.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output indent="yes" omit-xml-declaration="yes"/>
    <xsl:param name="namespace"/>
    <xsl:param name="stylesheet"/>
    <xsl:param name="googleBaseUrl"/>
    
    <xsl:template match="/GSP">
        
        <!-- Display out any directory links -->
        <xsl:if test="count(GM) > 0">
            <div style="border: thin solid rgb(177, 198, 242); margin: 7px; padding: 7px;">
                <div style="padding-bottom: 3px; font-weight: bold;">Directory Links</div>
                <xsl:apply-templates select="GM"/>
            </div>            
        </xsl:if>
        
        <!-- Display spelling suggestions -->
        <xsl:apply-templates select="Spelling"/>
        
        <!-- Display search results -->
        <xsl:choose>
            <xsl:when test="count(RES/R) > 0">
                <!-- Display search matches -->
                <xsl:apply-templates select="RES/R"/>

                <!-- Display a link to more results -->
                <xsl:apply-templates select="RES/NB"/>
            </xsl:when>

            <xsl:otherwise>No results found.</xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    <!-- Search matches -->
    <xsl:template match="R">
        <div class="gs-webResult gs-result">
            <div class="gs-title">
                <a class="gs-title" href="{U}" target="_blank">
                    <xsl:value-of select="T" disable-output-escaping="yes"/>
                </a>
            </div>
            <div class="gs-snippet">
                <xsl:value-of select="S" disable-output-escaping="yes"/>
            </div>
            <div class="gs-visibleUrl gs-visibleUrl-short"><xsl:value-of select="U" disable-output-escaping="yes"/></div>
        </div>
    </xsl:template>
    
    <!-- Directory listings -->
    <xsl:template match="GM">
        <div>
            <div>
                <a target="_blank" href="{GL}"><xsl:value-of select="GD" disable-output-escaping="yes"/></a>
            </div>
            <div style="padding-left: 5px;"><xsl:value-of select="GL"/></div>
        </div>        
    </xsl:template>
    
    <!-- Spelling suggestions -->
    <xsl:template match="Spelling">
        <div>
            Did you mean:
            <a href="javascript:;">
                <xsl:attribute name="onclick">return useGsaSuggestion(this, '<xsl:value-of select="$namespace"/>');</xsl:attribute>
                <xsl:value-of select="Suggestion" disable-output-escaping="yes"/>
            </a>
        </div>
    </xsl:template>
    
    <!-- Link to more results -->
    <xsl:template match="NB">
        <div>
            <a href="{$googleBaseUrl}{NU}&amp;proxystylesheet={$stylesheet}" target="_blank" style="margin-top: 10px;">
                More results . . .
            </a>
        </div>
    </xsl:template>

</xsl:stylesheet>
