/*
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var googleSearchInitialized = false;
var campusSearchInitialized = false;

function addGoogleStylesheet() {
	// Add CSS style sheets to the page.  We do this through JavaScript because
	// the portal can't add <link/>s added in the head.
	if(document.createStyleSheet) {
		document.createStyleSheet('https://www.google.com/uds/css/gsearch.css');
	} else {
		var styles = "@import url(' https://www.google.com/uds/css/gsearch.css ');";
		var newSS=document.createElement('link');
		newSS.rel='stylesheet';
		newSS.href='data:text/css,'+escape(styles);
		document.getElementsByTagName("head")[0].appendChild(newSS);
	}
}

function searchCampusWeb(form, namespace) {
	if (!campusSearchInitialized) {
   		campusSearchInitialized = true;
   		addGoogleStylesheet();
   	}
   	var searchDiv = $("#" + namespace + "campusWebResults");
   	var params = {q: form.searchtext.value, num: 4, namespace: namespace};
   	if (form.engine != undefined)
   		params.site = form.engine.value;
   	$.get(gsaSearchUrl, 
   		params,
   		function(xml){
   			searchDiv.html(xml);
   		}
   	);
   	
   	return false;
}
   
function useGsaSuggestion(suggestion, namespace) {
	console.debug(suggestion);
	var form = $("#" + namespace + "gsaSearchForm").get(0);
	form.searchtext.value = $(suggestion).text();
	return searchCampusWeb(form, namespace);
}
   
function searchPersonDirectory(form, namespace) {
	$.get(personSearchUrl, 
		{ name: form.searchtext.value }, 
		function(xml){
			$("#" + namespace + "directoryResults").html(xml);
		}
	);
	return false;
}

function toggleLdapPerson(div) {
	if (div.className == 'inactiveLdapPerson') {
		div.className = 'activeLdapPerson';
	} else {
		div.className = 'inactiveLdapPerson';
	}
	return false;
}

function searchGoogleFrame(form, namespace) {
   	var searchtype = form.engine.value;
   	var query = form.searchtext.value;
   	var frame = $("#" + namespace + "googleFrame");
   	if (!googleSearchInitialized) {
   		frame.attr("src", googleFrameUrl + "?searchtype=" + searchtype + "&query=" + query + "&namespace=" + namespace);
   		googleSearchInitialized = true;
   	} else
		window.frames.googleFrame.searchGoogle(searchtype, query);
   	frame.css("display", "block");
	return false;
}

function calcGoogleSearchHeight(namespace) {
	//find the height of the internal page
	var the_height = document.getElementById(namespace + 'googleFrame').contentWindow.document.body.scrollHeight;
	//change the height of the iframe
	$('#' + namespace + 'googleFrame').css("height", the_height + 30 + 'px');
}
