/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resource.aggr.mojo;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.jasig.resource.aggr.AggregationException;
import org.jasig.resource.aggr.ResourcesAggregatorImpl;
import org.jasig.resource.aggr.mojo.CommonsLogToMavenLog;

public class SkinResourcesAggregatorMojo
extends AbstractMojo {
    private int cssLineBreakColumnNumber = 10000;
    private boolean disableJsOptimizations = false;
    private boolean displayJsWarnings = true;
    private int jsLineBreakColumnNumber = 10000;
    private boolean obfuscateJs = true;
    private boolean preserveAllSemiColons = true;
    private String digestAlgorithm = "MD5";
    private File skinConfigurationFile;
    private String skinOutputDirectory;
    private String sharedJavaScriptDirectory;
    private String encoding;
    private File baseOutputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        CommonsLogToMavenLog logWrapper = new CommonsLogToMavenLog(log);
        try {
            ResourcesAggregatorImpl aggr = new ResourcesAggregatorImpl((org.apache.commons.logging.Log)logWrapper, this.encoding);
            aggr.setCssLineBreakColumnNumber(this.cssLineBreakColumnNumber);
            aggr.setDisableJsOptimizations(this.disableJsOptimizations);
            aggr.setDisplayJsWarnings(this.displayJsWarnings);
            aggr.setJsLineBreakColumnNumber(this.jsLineBreakColumnNumber);
            aggr.setObfuscateJs(this.obfuscateJs);
            aggr.setPreserveAllSemiColons(this.preserveAllSemiColons);
            aggr.setDigestAlgorithm(this.digestAlgorithm);
            File fullOutputDirectory = new File(this.baseOutputDirectory, this.skinOutputDirectory);
            if (this.sharedJavaScriptDirectory == null) {
                aggr.aggregate(this.skinConfigurationFile, fullOutputDirectory);
            } else {
                File fullSharedJavaScriptDirectory = new File(this.baseOutputDirectory, this.sharedJavaScriptDirectory);
                aggr.aggregate(this.skinConfigurationFile, fullOutputDirectory, fullSharedJavaScriptDirectory);
            }
        }
        catch (AggregationException e) {
            throw new MojoExecutionException("aggregation failed", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException occurred", (Exception)e);
        }
    }
}

