/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resource.aggr;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class RelativePath {
    private static List<String> getPathList(File file) throws IOException {
        LinkedList<String> pathParts = new LinkedList<String>();
        for (file = file.getCanonicalFile(); file != null; file = file.getParentFile()) {
            pathParts.add(file.getName());
        }
        return pathParts;
    }

    private static String matchPathLists(List<String> basePath, List<String> filePath) {
        StringBuilder relativePath = new StringBuilder();
        ListIterator<String> basePathItr = basePath.listIterator(basePath.size() - 1);
        ListIterator<String> filePathItr = filePath.listIterator(filePath.size() - 1);
        while (basePathItr.hasPrevious() && filePathItr.hasPrevious()) {
            if (basePathItr.previous().equals(filePathItr.previous())) continue;
            basePathItr.next();
            filePathItr.next();
            break;
        }
        while (basePathItr.hasPrevious()) {
            relativePath.append("..").append(File.separator);
            basePathItr.previous();
        }
        while (filePathItr.hasPrevious()) {
            relativePath.append(filePathItr.previous());
            if (!filePathItr.hasPrevious()) continue;
            relativePath.append(File.separator);
        }
        return relativePath.toString();
    }

    public static String getRelativePath(File home, File f) throws IOException {
        List<String> homelist = RelativePath.getPathList(home);
        List<String> filelist = RelativePath.getPathList(f);
        return RelativePath.matchPathLists(homelist, filelist);
    }
}

