/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resource.aggr;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class TrimmingWriter
extends FilterWriter {
    private final StringBuilder trimEndBuffer = new StringBuilder();
    private boolean trimmingStart = true;
    private int charCount = 0;

    public TrimmingWriter(Writer out) {
        super(out);
    }

    public int getCharCount() {
        return this.charCount;
    }

    @Override
    public void write(int c) throws IOException {
        if (this.trimmingStart) {
            if (Character.isWhitespace(c)) {
                return;
            }
            this.trimmingStart = false;
        } else {
            if (Character.isWhitespace(c)) {
                this.trimEndBuffer.append((char)c);
                return;
            }
            if (this.trimEndBuffer.length() > 0) {
                this.flushBuffer();
            }
        }
        ++this.charCount;
        super.write(c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int idx;
        if (this.trimmingStart) {
            for (idx = 0; this.trimmingStart && idx < len; ++idx) {
                if (Character.isWhitespace(cbuf[idx + off])) continue;
                this.trimmingStart = false;
                off += idx;
                len -= idx;
            }
            if (idx == len) {
                return;
            }
        }
        for (idx = 0; idx < len && Character.isWhitespace(cbuf[off + len - idx - 1]); ++idx) {
        }
        if (idx != len && this.trimEndBuffer.length() > 0) {
            this.flushBuffer();
        }
        if (idx > 0) {
            this.trimEndBuffer.append(cbuf, off + len - idx, idx);
            len -= idx;
        }
        this.charCount += len;
        super.write(cbuf, off, len);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        int idx;
        if (this.trimmingStart) {
            for (idx = 0; this.trimmingStart && idx < len; ++idx) {
                if (Character.isWhitespace(str.charAt(idx + off))) continue;
                this.trimmingStart = false;
                off += idx;
                len -= idx;
            }
            if (idx == len) {
                return;
            }
        }
        for (idx = 0; idx < len && Character.isWhitespace(str.charAt(off + len - idx - 1)); ++idx) {
        }
        if (idx != len && this.trimEndBuffer.length() > 0) {
            this.flushBuffer();
        }
        if (idx > 0) {
            this.trimEndBuffer.append(str, off + len - idx, off + len);
            len -= idx;
        }
        this.charCount += len;
        super.write(str, off, len);
    }

    @Override
    public void close() throws IOException {
        this.trimEndBuffer.setLength(0);
        this.trimEndBuffer.trimToSize();
        super.close();
    }

    protected void flushBuffer() throws IOException {
        String buffer = this.trimEndBuffer.toString();
        int bufferLength = buffer.length();
        super.write(buffer, 0, bufferLength);
        this.charCount += bufferLength;
        this.trimEndBuffer.setLength(0);
    }
}

