/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.fortuna.ical4j.model.component.VEvent;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.time.DateUtils;
import org.jasig.schedassist.CalendarAccountNotFoundException;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.SchedulingAssistantService;
import org.jasig.schedassist.SchedulingException;
import org.jasig.schedassist.impl.owner.AvailableScheduleDao;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.impl.visitor.NotAVisitorException;
import org.jasig.schedassist.impl.visitor.VisitorDao;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class AppointmentTool {
    public static final String CONFIG = System.getProperty("org.jasig.schedassist.impl.AppointmentTool.CONFIG", "cli-tools-SAMPLE.xml");
    public static final String CREATE = "create";
    public static final String OWNER_ARG = "-owner";
    public static final String VISITOR_ARG = "-visitor";
    public static final String START_ARG = "-start";
    public static final String DURATION_ARG = "-duration";
    public static final String DATE_FORMAT = "yyyyMMdd-HHmm";
    private ICalendarAccountDao calendarAccountDao;
    private OwnerDao ownerDao;
    private VisitorDao visitorDao;
    private AvailableScheduleDao availableScheduleDao;
    private SchedulingAssistantService schedulingAssistantService;

    public AppointmentTool(SchedulingAssistantService schedulingAssistantService, ICalendarAccountDao calendarAccountDao, OwnerDao ownerDao, VisitorDao visitorDao, AvailableScheduleDao availableScheduleDao) {
        this.schedulingAssistantService = schedulingAssistantService;
        this.calendarAccountDao = calendarAccountDao;
        this.ownerDao = ownerDao;
        this.visitorDao = visitorDao;
        this.availableScheduleDao = availableScheduleDao;
    }

    public VEvent createAvailableAppointment(String visitorUsername, String ownerUsername, Date startDate, Date endDate) throws CalendarAccountNotFoundException, NotAVisitorException, SchedulingException {
        ICalendarAccount visitorUser = this.calendarAccountDao.getCalendarAccount(visitorUsername);
        ICalendarAccount ownerUser = this.calendarAccountDao.getCalendarAccount(ownerUsername);
        IScheduleVisitor visitor = this.visitorDao.toVisitor(visitorUser);
        IScheduleOwner owner = this.ownerDao.locateOwner(ownerUser);
        if (null == owner) {
            throw new SchedulingException("owner not registered with Available");
        }
        AvailableBlock block = this.availableScheduleDao.retrieveTargetBlock(owner, startDate);
        if (null == block) {
            throw new SchedulingException("owner does not have availability at " + startDate);
        }
        VEvent result = this.schedulingAssistantService.scheduleAppointment(visitor, owner, block, "test appointment created by WiscCal administrator");
        return result;
    }

    public static void main(String[] args) throws CalendarAccountNotFoundException, NotAVisitorException, SchedulingException {
        if (args.length == 0) {
            System.err.println("Usage: AppointmentTool create [-owner username] [-visitor username] [-start YYYYmmdd-hhmm] [-duration minutes]");
            System.exit(1);
        }
        if (CREATE.equals(args[0])) {
            String visitorUsername = null;
            String ownerUsername = null;
            Date startTime = null;
            int duration = 30;
            for (int i = 1; i < args.length; ++i) {
                if (OWNER_ARG.equalsIgnoreCase(args[i])) {
                    ownerUsername = args[++i];
                    continue;
                }
                if (VISITOR_ARG.equalsIgnoreCase(args[i])) {
                    visitorUsername = args[++i];
                    continue;
                }
                if (START_ARG.equalsIgnoreCase(args[i])) {
                    String start = args[++i];
                    SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
                    try {
                        startTime = df.parse(start);
                    }
                    catch (ParseException e) {
                        System.err.println("Invalid format for start parameter, must match: yyyyMMdd-HHmm");
                        System.exit(1);
                    }
                    continue;
                }
                if (!DURATION_ARG.equalsIgnoreCase(args[i])) continue;
                String dur = args[++i];
                duration = Integer.parseInt(dur);
            }
            Validate.notEmpty(ownerUsername, (String)"owner argument cannot be empty");
            Validate.notEmpty(visitorUsername, (String)"visitor argument cannot be empty");
            Validate.notNull(startTime, (String)"start argument cannot be empty");
            ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext(CONFIG);
            AppointmentTool tool = new AppointmentTool((SchedulingAssistantService)applicationContext.getBean("schedulingAssistantService"), (ICalendarAccountDao)applicationContext.getBean("calendarAccountDao"), (OwnerDao)applicationContext.getBean("ownerDao"), (VisitorDao)applicationContext.getBean("visitorDao"), (AvailableScheduleDao)applicationContext.getBean("availableScheduleDao"));
            Date endDate = DateUtils.addMinutes((Date)startTime, (int)duration);
            VEvent event = tool.createAvailableAppointment(visitorUsername, ownerUsername, startTime, endDate);
            System.out.println("Event successfully created: ");
            System.out.println(event.toString());
        } else {
            System.err.println("Unrecognized command: " + args[0]);
            System.exit(1);
        }
    }
}

