/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl;

import java.util.Date;
import java.util.List;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.component.VEvent;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.ICalendarDataDao;
import org.jasig.schedassist.NoAppointmentExistsException;
import org.jasig.schedassist.SchedulingAssistantService;
import org.jasig.schedassist.SchedulingException;
import org.jasig.schedassist.impl.events.AppointmentCancelledEvent;
import org.jasig.schedassist.impl.events.AppointmentCreatedEvent;
import org.jasig.schedassist.impl.events.AppointmentJoinedEvent;
import org.jasig.schedassist.impl.events.AppointmentLeftEvent;
import org.jasig.schedassist.impl.owner.AvailableScheduleDao;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.AvailableSchedule;
import org.jasig.schedassist.model.IEventUtils;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.model.IVisibleScheduleBuilder;
import org.jasig.schedassist.model.VisibleSchedule;
import org.jasig.schedassist.model.VisibleWindow;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.stereotype.Service;

@Service(value="schedulingAssistantService")
public final class SchedulingAssistantServiceImpl
implements SchedulingAssistantService,
ApplicationEventPublisherAware {
    private ICalendarDataDao calendarDao;
    private AvailableScheduleDao availableScheduleDao;
    private ApplicationEventPublisher applicationEventPublisher;
    private IVisibleScheduleBuilder visibleScheduleBuilder;
    private IEventUtils eventUtils;
    private Log LOG = LogFactory.getLog(this.getClass());

    @Autowired
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Autowired
    public void setAvailableScheduleDao(AvailableScheduleDao availableScheduleDao) {
        this.availableScheduleDao = availableScheduleDao;
    }

    @Autowired
    public void setCalendarDataDao(ICalendarDataDao calendarDataDao) {
        this.calendarDao = calendarDataDao;
    }

    @Autowired
    public void setVisibleScheduleBuilder(IVisibleScheduleBuilder visibleScheduleBuilder) {
        this.visibleScheduleBuilder = visibleScheduleBuilder;
    }

    @Autowired
    public void setEventUtils(IEventUtils eventUtils) {
        this.eventUtils = eventUtils;
    }

    public VEvent getExistingAppointment(AvailableBlock targetBlock, IScheduleOwner owner) {
        VEvent result = this.calendarDao.getExistingAppointment(owner, targetBlock);
        return result;
    }

    public VisibleSchedule getVisibleSchedule(IScheduleVisitor visitor, IScheduleOwner owner) {
        Date[] windowBoundaries = this.calculateOwnerWindowBounds(owner);
        VisibleSchedule result = this.getVisibleSchedule(visitor, owner, windowBoundaries[0], windowBoundaries[1]);
        return result;
    }

    public VisibleSchedule getVisibleSchedule(IScheduleVisitor visitor, IScheduleOwner owner, Date start, Date end) {
        Validate.notNull((Object)start, (String)"start parameter cannot be null");
        Validate.notNull((Object)end, (String)"start parameter cannot be null");
        Date[] windowBoundaries = this.calculateOwnerWindowBounds(owner);
        Date localStart = start;
        if (start.before(windowBoundaries[0]) || start.after(windowBoundaries[1])) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("ignoring submitted start for getVisibleSchedule: " + start + " (using windowBoundary of " + windowBoundaries[0] + ")"));
            }
            localStart = windowBoundaries[0];
        }
        Date localEnd = end;
        if (end.after(windowBoundaries[1])) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("ignoring submitted end for getVisibleSchedule: " + end + " (using windowBoundary of " + windowBoundaries[1] + ")"));
            }
            localEnd = windowBoundaries[1];
        }
        Calendar calendar = this.calendarDao.getCalendar(owner.getCalendarAccount(), localStart, localEnd);
        AvailableSchedule schedule = this.availableScheduleDao.retrieve(owner);
        VisibleSchedule result = this.visibleScheduleBuilder.calculateVisibleSchedule(localStart, localEnd, calendar, schedule, owner, visitor);
        return result;
    }

    public List<AvailableBlock> calculateVisitorConflicts(IScheduleVisitor visitor, IScheduleOwner owner, Date start, Date end) {
        Date[] windowBoundaries = this.calculateOwnerWindowBounds(owner);
        Date localStart = start;
        if (start.before(windowBoundaries[0])) {
            localStart = windowBoundaries[0];
        }
        Date localEnd = end;
        if (end.after(windowBoundaries[1])) {
            localEnd = windowBoundaries[1];
        }
        AvailableSchedule availableSchedule = this.availableScheduleDao.retrieve(owner, localStart, localEnd);
        Calendar calendar = this.calendarDao.getCalendar(visitor.getCalendarAccount(), localStart, localEnd);
        VisibleSchedule result = this.visibleScheduleBuilder.calculateVisitorConflicts(localStart, localEnd, calendar, availableSchedule, owner.getPreferredMeetingDurations(), visitor);
        List visitorConflicts = result.getBusyList();
        return visitorConflicts;
    }

    protected Date[] calculateOwnerWindowBounds(IScheduleOwner owner) {
        VisibleWindow window = owner.getPreferredVisibleWindow();
        Date now = new Date();
        Date startTime = DateUtils.addHours((Date)now, (int)window.getWindowHoursStart());
        Date boundary = DateUtils.addWeeks((Date)now, (int)window.getWindowWeeksEnd());
        return new Date[]{startTime, boundary};
    }

    public void cancelAppointment(IScheduleVisitor visitor, IScheduleOwner owner, VEvent event, AvailableBlock block, String cancelReason) throws SchedulingException {
        if (owner.isSamePerson(visitor)) {
            this.LOG.warn((Object)("ignoring request to cancelAppointment for owner/visitor same person: " + owner));
            return;
        }
        VEvent availableAppointment = this.calendarDao.getExistingAppointment(owner, block);
        if (null == availableAppointment || this.eventUtils.isAttendingMatch(availableAppointment, visitor, owner)) {
            if (null == availableAppointment.getProperty("X-UW-AVAILABLE-VERSION") || block.getVisitorLimit() == 1) {
                this.calendarDao.cancelAppointment(visitor, owner, availableAppointment);
                if (null != this.applicationEventPublisher) {
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)new AppointmentCancelledEvent(availableAppointment, owner, visitor, block, cancelReason));
                }
                return;
            }
            int currentVisitorCount = this.eventUtils.getScheduleVisitorCount(availableAppointment);
            if (currentVisitorCount == 1) {
                this.calendarDao.cancelAppointment(visitor, owner, availableAppointment);
            } else {
                this.calendarDao.leaveAppointment(visitor, owner, availableAppointment);
            }
            if (null != this.applicationEventPublisher) {
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new AppointmentLeftEvent(availableAppointment, owner, visitor, block));
            }
            return;
        }
        this.LOG.error((Object)("no appointment found within block " + block));
        throw new NoAppointmentExistsException("no matching appointment can be found");
    }

    public VEvent scheduleAppointment(IScheduleVisitor visitor, IScheduleOwner owner, AvailableBlock block, String eventDescription) throws SchedulingException {
        if (owner.isSamePerson(visitor)) {
            this.LOG.warn((Object)("ignoring request to scheduleAppointment for owner/visitor same person: " + owner));
            return null;
        }
        AvailableBlock ownerPersistedBlock = this.availableScheduleDao.retrieveTargetBlock(owner, block.getStartTime());
        if (null == ownerPersistedBlock) {
            throw new SchedulingException("requested time is not available in schedule: " + block);
        }
        if (ownerPersistedBlock.getVisitorLimit() == 1) {
            this.calendarDao.checkForConflicts(owner, block);
            VEvent event = this.calendarDao.createAppointment(visitor, owner, block, eventDescription);
            if (null != this.applicationEventPublisher) {
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new AppointmentCreatedEvent(event, owner, visitor, block, eventDescription));
            }
            return event;
        }
        VEvent existingAppointment = this.calendarDao.getExistingAppointment(owner, block);
        if (null == existingAppointment) {
            this.calendarDao.checkForConflicts(owner, block);
            VEvent event = this.calendarDao.createAppointment(visitor, owner, block, eventDescription);
            if (null != this.applicationEventPublisher) {
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new AppointmentJoinedEvent(event, owner, visitor, block));
            }
            return event;
        }
        int visitorCount = this.eventUtils.getScheduleVisitorCount(existingAppointment);
        if (visitorCount < ownerPersistedBlock.getVisitorLimit()) {
            VEvent event = this.calendarDao.joinAppointment(visitor, owner, existingAppointment);
            if (null != this.applicationEventPublisher) {
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new AppointmentJoinedEvent(event, owner, visitor, block));
            }
            return event;
        }
        throw new SchedulingException("visitor limit for this appointment has been met");
    }
}

