/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.events;

import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.jasig.schedassist.impl.events.AbstractAppointmentEvent;
import org.jasig.schedassist.impl.events.AppointmentCancelledEvent;
import org.jasig.schedassist.impl.events.AppointmentCreatedEvent;
import org.jasig.schedassist.impl.events.AppointmentJoinedEvent;
import org.jasig.schedassist.impl.events.AppointmentLeftEvent;
import org.jasig.schedassist.impl.reminder.IReminder;
import org.jasig.schedassist.impl.reminder.ReminderService;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.Reminders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ReminderServiceApplicationListener
implements ApplicationListener<AbstractAppointmentEvent> {
    private ReminderService reminderService;

    @Autowired
    public void setReminderService(ReminderService reminderService) {
        this.reminderService = reminderService;
    }

    @Async
    public void onApplicationEvent(AbstractAppointmentEvent event) {
        IScheduleOwner owner = event.getOwner();
        Reminders reminderPreference = owner.getRemindersPreference();
        if (reminderPreference.isEnabled()) {
            IReminder reminder;
            if (event instanceof AppointmentCreatedEvent || event instanceof AppointmentJoinedEvent) {
                Date sendTime = DateUtils.addHours((Date)event.getBlock().getStartTime(), (int)(-reminderPreference.getHours()));
                if (sendTime.after(new Date())) {
                    this.reminderService.createEventReminder(event.getOwner(), event.getVisitor().getCalendarAccount(), event.getBlock(), event.getEvent(), sendTime);
                }
            } else if ((event instanceof AppointmentCancelledEvent || event instanceof AppointmentLeftEvent) && (reminder = this.reminderService.getReminder(owner, event.getVisitor().getCalendarAccount(), event.getBlock())) != null) {
                this.reminderService.deleteEventReminder(reminder);
            }
        }
    }
}

