/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.owner;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.impl.owner.PersistenceScheduleOwner;
import org.jasig.schedassist.impl.owner.PersistenceScheduleOwnerRowMapper;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;

public final class ScheduleOwnerAuditor
extends SimpleJdbcDaoSupport {
    public static final String CONFIG_SYSTEM_PROPERTY = "org.jasig.schedassist.impl.owner.ScheduleOwnerAuditor.CONFIG";
    public static final String CONFIG = System.getProperty("org.jasig.schedassist.impl.owner.ScheduleOwnerAuditor.CONFIG", "cli-tools.xml");
    private final Log LOG = LogFactory.getLog(((Object)((Object)this)).getClass());
    private OwnerDao ownerDao;
    private ICalendarAccountDao calendarAccountDao;
    private boolean purge = false;

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    @Autowired
    public void setCalendarAccountDao(@Qualifier(value="composite") ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    public void setPurge(boolean purge) {
        this.purge = purge;
    }

    protected List<PersistenceScheduleOwner> gatherAllScheduleOwnerRecords() {
        List ownerRecords = this.getSimpleJdbcTemplate().query("select * from owners", (RowMapper)new PersistenceScheduleOwnerRowMapper(), new Object[0]);
        return ownerRecords;
    }

    protected void auditRecord(PersistenceScheduleOwner owner) {
        ICalendarAccount byUsername = this.calendarAccountDao.getCalendarAccount(owner.getUsername());
        if (null == byUsername || !byUsername.isEligible()) {
            this.LOG.debug((Object)("no calendar account found for username " + owner.getUsername()));
            ICalendarAccount byUniqueId = this.calendarAccountDao.getCalendarAccountFromUniqueId(owner.getCalendarUniqueId());
            if (null != byUniqueId && byUniqueId.isEligible()) {
                this.LOG.warn((Object)("found calendarAccount by unique id that has different username from records, owner record: " + owner + ", account: " + byUniqueId));
                int rows = this.getSimpleJdbcTemplate().update("update owners set username = ? where external_unique_id = ?", new Object[]{byUniqueId.getUsername(), owner.getCalendarUniqueId()});
                if (rows == 1) {
                    this.LOG.warn((Object)("successfully updated record for " + byUniqueId));
                } else {
                    this.LOG.error((Object)("failed to update records for " + byUniqueId));
                }
                return;
            }
        } else {
            this.LOG.info((Object)(owner + " still eligible, corresponds to ICalendarAccount: " + byUsername));
            return;
        }
        this.LOG.warn((Object)("no ICalendarAccount found for record: " + owner));
        if (this.purge) {
            ICalendarAccount ineligible = this.constructCalendarUserForRemoval(owner);
            IScheduleOwner ownerAccount = this.ownerDao.locateOwner(ineligible);
            this.ownerDao.removeAccount(ownerAccount);
            this.LOG.warn((Object)("removed record: " + owner));
        }
    }

    private ICalendarAccount constructCalendarUserForRemoval(PersistenceScheduleOwner owner) {
        DeactivatingCalendarAccount ineligible = new DeactivatingCalendarAccount();
        ineligible.setCalendarUniqueId(owner.getCalendarUniqueId());
        ineligible.setUsername(owner.getUsername());
        return ineligible;
    }

    public static void main(String[] args) {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(CONFIG);
        ScheduleOwnerAuditor auditor = (ScheduleOwnerAuditor)((Object)context.getBean("scheduleOwnerAuditor"));
        List<PersistenceScheduleOwner> allOwnerRecords = auditor.gatherAllScheduleOwnerRecords();
        for (PersistenceScheduleOwner owner : allOwnerRecords) {
            auditor.auditRecord(owner);
        }
    }

    static final class DeactivatingCalendarAccount
    implements ICalendarAccount {
        private static final long serialVersionUID = 1L;
        private String calendarUniqueId;
        private String username;

        DeactivatingCalendarAccount() {
        }

        public String getAttributeValue(String attributeName) {
            return null;
        }

        public Map<String, String> getAttributes() {
            return null;
        }

        public String getCalendarLoginId() {
            return null;
        }

        public String getCalendarUniqueId() {
            return this.calendarUniqueId;
        }

        public String getDisplayName() {
            return null;
        }

        public String getEmailAddress() {
            return null;
        }

        public String getUsername() {
            return this.username;
        }

        public boolean isEligible() {
            return false;
        }

        public void setCalendarUniqueId(String calendarUniqueId) {
            this.calendarUniqueId = calendarUniqueId;
        }

        public void setUsername(String username) {
            this.username = username;
        }
    }
}

