/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.owner;

import com.googlecode.ehcache.annotations.Cacheable;
import com.googlecode.ehcache.annotations.TriggersRemove;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.impl.owner.PublicProfileAlreadyExistsException;
import org.jasig.schedassist.impl.owner.PublicProfileDao;
import org.jasig.schedassist.impl.owner.PublicProfileIdRowMapper;
import org.jasig.schedassist.impl.owner.PublicProfileRowMapper;
import org.jasig.schedassist.impl.owner.PublicProfileTagRowMapper;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.Preferences;
import org.jasig.schedassist.model.PublicProfile;
import org.jasig.schedassist.model.PublicProfileId;
import org.jasig.schedassist.model.PublicProfileTag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="publicProfileDao")
public class SpringJDBCPublicProfileDaoImpl
implements PublicProfileDao {
    protected static final int PROFILE_KEY_LENGTH = 8;
    private Log LOG = LogFactory.getLog(this.getClass());
    private SimpleJdbcTemplate simpleJdbcTemplate;
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    @Autowired
    public void setDataSource(DataSource dataSource) {
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
        this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
    }

    @Override
    @Transactional
    @TriggersRemove(cacheName={"publicProfileCache"}, removeAll=true)
    public PublicProfile createPublicProfile(IScheduleOwner owner, String profileDescription) throws PublicProfileAlreadyExistsException {
        if (null != this.locatePublicProfileByOwner(owner)) {
            throw new PublicProfileAlreadyExistsException("owner already has a public profile: " + owner);
        }
        String uniqueKey = this.generateNewProfileKey();
        this.simpleJdbcTemplate.update("insert into public_profiles (owner_id,owner_display_name,profile_key,profile_description) values (?,?,?,?)", new Object[]{owner.getId(), owner.getCalendarAccount().getDisplayName(), uniqueKey, profileDescription});
        PublicProfile result = this.locatePublicProfileByKey(uniqueKey);
        this.LOG.info((Object)("created new public profile " + result));
        return result;
    }

    protected String generateNewProfileKey() {
        boolean uniqueFound = false;
        String uniqueKey = null;
        while (!uniqueFound) {
            uniqueKey = RandomStringUtils.randomAlphabetic((int)8);
            List existing = this.simpleJdbcTemplate.query("select profile_key from public_profiles where profile_key = ?", (RowMapper)new SingleColumnRowMapper(), new Object[]{uniqueKey});
            uniqueFound = existing.size() == 0;
        }
        return uniqueKey;
    }

    @Override
    @Cacheable(cacheName="publicProfileCache")
    public List<PublicProfileId> getPublicProfileIds() {
        List profileIds = this.simpleJdbcTemplate.query("select profile_key, owner_display_name from public_profiles", (RowMapper)new PublicProfileIdRowMapper(), new Object[0]);
        return profileIds;
    }

    @Override
    @Cacheable(cacheName="publicProfileCache")
    public List<PublicProfileId> getPublicProfileIds(int indexStart, int indexEnd) {
        List<PublicProfileId> all = this.getPublicProfileIds();
        Collections.sort(all);
        if (indexStart < 0) {
            indexStart = 0;
        }
        if (indexEnd > all.size()) {
            indexEnd = all.size();
        }
        List<PublicProfileId> sublist = all.subList(indexStart, indexEnd);
        return sublist;
    }

    @Override
    public List<PublicProfileId> getAdvisorPublicProfileIds() {
        List profileIds = this.simpleJdbcTemplate.query("select prof.profile_key, prof.owner_display_name from public_profiles prof, preferences pref where pref.preference_key = '" + Preferences.ADVISOR_SHARE_WITH_STUDENTS.getKey() + "' and pref.preference_value='true' and prof.owner_id = pref.owner_id", (RowMapper)new PublicProfileIdRowMapper(), new Object[0]);
        return profileIds;
    }

    @Override
    public List<PublicProfileId> getInstructorPublicProfileIds() {
        List profileIds = this.simpleJdbcTemplate.query("select prof.profile_key, prof.owner_display_name from public_profiles prof, preferences pref where pref.preference_key = '" + Preferences.INSTRUCTOR_SHARE_WITH_STUDENTS.getKey() + "' and pref.preference_value='true' and prof.owner_id = pref.owner_id", (RowMapper)new PublicProfileIdRowMapper(), new Object[0]);
        return profileIds;
    }

    @Override
    @Cacheable(cacheName="publicProfileCache")
    public PublicProfile locatePublicProfileByKey(String profileKey) {
        List profiles = this.simpleJdbcTemplate.query("select prof.owner_id, prof.owner_display_name, prof.profile_key, prof.profile_description, pref.preference_value as noteboard from public_profiles prof, preferences pref where prof.profile_key = ? and prof.owner_id = pref.owner_id and pref.preference_key = '" + Preferences.NOTEBOARD.getKey() + "'", (RowMapper)new PublicProfileRowMapper(), new Object[]{profileKey});
        PublicProfile result = (PublicProfile)DataAccessUtils.singleResult((Collection)profiles);
        return result;
    }

    @Override
    public PublicProfile locatePublicProfileByOwner(IScheduleOwner owner) {
        List profiles = this.simpleJdbcTemplate.query("select prof.owner_id, prof.owner_display_name, prof.profile_key, prof.profile_description, pref.preference_value as noteboard from public_profiles prof, preferences pref where prof.owner_id = ? and prof.owner_id = pref.owner_id and pref.preference_key = '" + Preferences.NOTEBOARD.getKey() + "'", (RowMapper)new PublicProfileRowMapper(), new Object[]{owner.getId()});
        PublicProfile result = (PublicProfile)DataAccessUtils.singleResult((Collection)profiles);
        return result;
    }

    @Override
    @Transactional
    @TriggersRemove(cacheName={"publicProfileCache"}, removeAll=true)
    public void removePublicProfile(PublicProfileId profileId) {
        this.simpleJdbcTemplate.update("delete from public_profiles where profile_key = ?", new Object[]{profileId.getProfileKey()});
        this.LOG.info((Object)("removed public profile " + profileId));
    }

    @Override
    @Transactional
    @TriggersRemove(cacheName={"publicProfileCache"}, removeAll=true)
    public PublicProfile updatePublicProfileDescription(PublicProfileId profileId, String profileDescription) {
        this.simpleJdbcTemplate.update("update public_profiles set profile_description = ? where profile_key = ?", new Object[]{profileDescription, profileId.getProfileKey()});
        PublicProfile updated = this.locatePublicProfileByKey(profileId.getProfileKey());
        this.LOG.info((Object)("created new public profile " + updated));
        return updated;
    }

    @Override
    public List<PublicProfileTag> getProfileTags(PublicProfileId profileId) {
        List tags = this.simpleJdbcTemplate.query("select profile_key, tag, tag_display from profile_tags where profile_key=?", (RowMapper)new PublicProfileTagRowMapper(), new Object[]{profileId.getProfileKey()});
        return tags;
    }

    @Override
    public Map<PublicProfileId, List<PublicProfileTag>> getProfileTagsBatch(List<PublicProfileId> profileIds) {
        final HashMap<String, PublicProfileId> idMap = new HashMap<String, PublicProfileId>();
        String sql = "select profile_key,tag,tag_display from profile_tags where profile_key in (:key)";
        for (PublicProfileId profileId : profileIds) {
            String key = profileId.getProfileKey();
            idMap.put(key, profileId);
        }
        HashMap paramMap = new HashMap();
        ArrayList keys = new ArrayList(idMap.keySet());
        paramMap.put("key", keys);
        Map results = (Map)this.namedParameterJdbcTemplate.query("select profile_key,tag,tag_display from profile_tags where profile_key in (:key)".toString(), paramMap, (ResultSetExtractor)new ResultSetExtractor<Map<PublicProfileId, List<PublicProfileTag>>>(){
            private final PublicProfileTagRowMapper TAG_ROW_MAPPER = new PublicProfileTagRowMapper();

            public Map<PublicProfileId, List<PublicProfileTag>> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<PublicProfileId, List<PublicProfileTag>> results = new HashMap<PublicProfileId, List<PublicProfileTag>>();
                while (rs.next()) {
                    PublicProfileTag tag = this.TAG_ROW_MAPPER.mapRow(rs, rs.getRow());
                    PublicProfileId profileId = (PublicProfileId)idMap.get(tag.getProfileKey());
                    ArrayList<PublicProfileTag> listForKey = (ArrayList<PublicProfileTag>)results.get(profileId);
                    if (listForKey == null) {
                        listForKey = new ArrayList<PublicProfileTag>();
                        results.put(profileId, listForKey);
                    }
                    listForKey.add(tag);
                }
                return results;
            }
        });
        return results;
    }

    @Override
    @Transactional
    public List<PublicProfileTag> setProfileTags(List<String> tags, PublicProfileId profileId) {
        int rows = this.simpleJdbcTemplate.update("delete from profile_tags where profile_key=?", new Object[]{profileId.getProfileKey()});
        this.LOG.debug((Object)("deleted " + rows + " from profile_tags for profile " + profileId));
        List<PublicProfileTag> toStore = this.stringAsTags(tags, profileId);
        SqlParameterSource[] batch = SqlParameterSourceUtils.createBatch((Object[])toStore.toArray());
        this.simpleJdbcTemplate.batchUpdate("insert into profile_tags (profile_key,tag,tag_display) values (:profileKey,:tag,:tagDisplay)", batch);
        this.LOG.debug((Object)("inserted " + tags.size() + " tags for " + profileId));
        return toStore;
    }

    @Override
    public List<PublicProfileId> getPublicProfileIdsWithTag(String tag) {
        if (StringUtils.isBlank((String)tag)) {
            return Collections.emptyList();
        }
        List profileIds = this.simpleJdbcTemplate.query("select tags.profile_key,prof.owner_display_name from profile_tags tags left join public_profiles prof on prof.profile_key=tags.profile_key where tag=?", (RowMapper)new PublicProfileIdRowMapper(), new Object[]{tag.toUpperCase()});
        return profileIds;
    }

    protected List<PublicProfileTag> stringAsTags(List<String> tags, PublicProfileId profileId) {
        ArrayList<PublicProfileTag> result = new ArrayList<PublicProfileTag>();
        for (String token : tags) {
            PublicProfileTag p = new PublicProfileTag();
            p.setProfileKey(profileId.getProfileKey());
            p.setTagDisplay(token);
            result.add(p);
        }
        return result;
    }
}

