/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.statistics;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jasig.schedassist.impl.EventType;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.impl.statistics.AppointmentEvent;
import org.jasig.schedassist.model.IScheduleOwner;
import org.springframework.jdbc.core.RowMapper;

public class AppointmentEventRowMapper
implements RowMapper<AppointmentEvent> {
    private OwnerDao ownerDao;

    public AppointmentEventRowMapper(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    public AppointmentEvent mapRow(ResultSet rs, int rowNum) throws SQLException {
        AppointmentEvent event = new AppointmentEvent();
        event.setEventId(rs.getLong("EVENT_ID"));
        long ownerId = rs.getLong("OWNER_ID");
        event.setOwnerId(ownerId);
        IScheduleOwner owner = this.ownerDao.locateOwnerByAvailableId(ownerId);
        event.setScheduleOwner(owner);
        String visitorId = rs.getString("VISITOR_ID");
        event.setVisitorId(visitorId);
        event.setEventType(EventType.valueOf(rs.getString("EVENT_TYPE")));
        event.setEventTimestamp(rs.getTimestamp("EVENT_TIMESTAMP"));
        event.setAppointmentStartTime(rs.getTimestamp("EVENT_START"));
        return event;
    }
}

