/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.visitor;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.impl.visitor.NotAVisitorException;
import org.jasig.schedassist.impl.visitor.VisitorDao;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleVisitor;

public final class CompositeVisitorDaoImpl
implements VisitorDao {
    private Log LOG = LogFactory.getLog(this.getClass());
    private List<VisitorDao> visitorDaos = Collections.emptyList();

    public void setVisitorDaos(List<VisitorDao> visitorDaos) {
        this.visitorDaos = visitorDaos;
    }

    @Override
    public IScheduleVisitor toVisitor(ICalendarAccount calendarUser) throws NotAVisitorException {
        for (VisitorDao component : this.visitorDaos) {
            try {
                IScheduleVisitor visitor = component.toVisitor(calendarUser);
                return visitor;
            }
            catch (NotAVisitorException e) {
                this.LOG.debug((Object)("caught NotAVisitorException for " + calendarUser + " from component " + component));
            }
        }
        throw new NotAVisitorException("no configured visitorDaos are able to return a ScheduleVisitor for " + calendarUser);
    }
}

