/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.support.AbstractDefaultAttributePersonAttributeDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RegexGatewayPersonAttributeDao
extends AbstractDefaultAttributePersonAttributeDao {
    private boolean matchAllPatterns = false;
    private boolean matchAllValues = false;
    private Map<String, Pattern> patterns = null;
    private IPersonAttributeDao targetPersonAttributeDao = null;

    public RegexGatewayPersonAttributeDao(String attributeName, String pattern, IPersonAttributeDao enclosed) {
        this.setDefaultAttributeName(attributeName);
        this.setPatterns(Collections.singletonMap(this.getDefaultAttributeName(), pattern));
        this.setTargetPersonAttributeDao(enclosed);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created RegexGatewayPersonAttributeDao with defaultAttributeName='" + this.getDefaultAttributeName() + "' and patterns=" + this.patterns));
        }
    }

    public Map<String, String> getPatterns() {
        if (this.patterns == null) {
            return null;
        }
        HashMap<String, String> toReturn = new HashMap<String, String>(this.patterns.size());
        for (Map.Entry<String, Pattern> patternEntry : this.patterns.entrySet()) {
            String attribute = patternEntry.getKey();
            Pattern pattern = patternEntry.getValue();
            toReturn.put(attribute, pattern.pattern());
        }
        return Collections.unmodifiableMap(toReturn);
    }

    public void setPatterns(Map<String, String> patterns) {
        Validate.notEmpty(patterns, (String)"patterns Map may not be null and must contain at least 1 mapping.");
        HashMap<String, Pattern> newPatterns = new HashMap<String, Pattern>(patterns.size());
        for (Map.Entry<String, String> patternEntry : patterns.entrySet()) {
            String attribute = patternEntry.getKey();
            String pattern = patternEntry.getValue();
            Validate.notNull((Object)pattern, (String)("pattern can not be null. attribute=" + attribute));
            Pattern compiledPattern = Pattern.compile(pattern);
            newPatterns.put(attribute, compiledPattern);
        }
        this.patterns = Collections.unmodifiableMap(newPatterns);
    }

    public IPersonAttributeDao getTargetPersonAttributeDao() {
        return this.targetPersonAttributeDao;
    }

    public void setTargetPersonAttributeDao(IPersonAttributeDao targetPersonAttributeDao) {
        Validate.notNull((Object)targetPersonAttributeDao, (String)"targetPersonAttributeDao may not be null");
        this.targetPersonAttributeDao = targetPersonAttributeDao;
    }

    public boolean isMatchAllPatterns() {
        return this.matchAllPatterns;
    }

    public void setMatchAllPatterns(boolean matchAllPatterns) {
        this.matchAllPatterns = matchAllPatterns;
    }

    public boolean isMatchAllValues() {
        return this.matchAllValues;
    }

    public void setMatchAllValues(boolean matchAllValues) {
        this.matchAllValues = matchAllValues;
    }

    public Map<String, List<Object>> getMultivaluedUserAttributes(Map<String, List<Object>> seed) {
        Validate.notNull(seed, (String)"Argument 'seed' cannot be null.");
        if (this.patterns == null || this.patterns.size() < 1) {
            throw new IllegalStateException("patterns Map may not be null and must contain at least 1 mapping.");
        }
        if (this.targetPersonAttributeDao == null) {
            throw new IllegalStateException("targetPersonAttributeDao may not be null");
        }
        boolean matchedPatterns = false;
        for (Map.Entry<String, Pattern> patternEntry : this.patterns.entrySet()) {
            String attributeName = patternEntry.getKey();
            List<Object> attributeValues = seed.get(attributeName);
            if (attributeValues == null) {
                if (!this.matchAllPatterns) continue;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("All patterns must match and attribute='" + attributeName + "' does not exist in the seed, returning null."));
                }
                return null;
            }
            Pattern compiledPattern = patternEntry.getValue();
            if (compiledPattern == null) {
                throw new IllegalStateException("Attribute '" + attributeName + "' has a null pattern");
            }
            boolean matchedValues = false;
            for (Object valueObj : attributeValues) {
                String value;
                try {
                    value = (String)valueObj;
                }
                catch (ClassCastException cce) {
                    IllegalArgumentException iae = new IllegalArgumentException("RegexGatewayPersonAttributeDao can only accept seeds who's values are String or List of String. Attribute '" + attributeName + "' has a non-String value.");
                    iae.initCause(cce);
                    throw iae;
                }
                Matcher valueMatcher = compiledPattern.matcher(value);
                matchedValues = valueMatcher.matches();
                if (matchedValues && !this.matchAllValues) {
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug((Object)("value='" + value + "' matched pattern='" + compiledPattern + "' and only one value match is needed, leaving value matching loop."));
                    break;
                }
                if (!matchedValues && this.matchAllValues) {
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug((Object)("value='" + value + "' did not match pattern='" + compiledPattern + "' and all values need to match, leaving value matching loop."));
                    break;
                }
                if (!this.logger.isDebugEnabled()) continue;
                if (matchedValues) {
                    this.logger.debug((Object)("value='" + value + "' matched pattern='" + compiledPattern + "' and all values need to match, continuing value matching loop."));
                    continue;
                }
                this.logger.debug((Object)("value='" + value + "' did not match pattern='" + compiledPattern + "' and only one value match is needed, continuing value matching loop."));
            }
            if ((matchedPatterns = matchedValues) && !this.matchAllPatterns) {
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug((Object)("pattern='" + compiledPattern + "' found a match and only one pattern match is needed, leaving pattern matching loop."));
                break;
            }
            if (!matchedPatterns && this.matchAllPatterns) {
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug((Object)("pattern='" + compiledPattern + "' did not find a match and all patterns need to match, leaving pattern matching loop."));
                break;
            }
            if (!this.logger.isDebugEnabled()) continue;
            if (matchedPatterns) {
                this.logger.debug((Object)("pattern='" + compiledPattern + "' found a match and all patterns need to match, continuing pattern matching loop."));
                continue;
            }
            this.logger.debug((Object)("pattern='" + compiledPattern + "' did not find a match and only one pattern match is needed, continuing pattern matching loop."));
        }
        if (matchedPatterns) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Matching criteria was met, delegating call to the targetPersonAttributeDao='" + this.targetPersonAttributeDao + "'"));
            }
            return this.targetPersonAttributeDao.getMultivaluedUserAttributes(seed);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Matching criteria was not met, return null");
        }
        return null;
    }

    public Set<String> getPossibleUserAttributeNames() {
        return this.targetPersonAttributeDao.getPossibleUserAttributeNames();
    }
}

