/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MultivaluedPersonAttributeUtils {
    public static Map parseAttributeToAttributeMapping(Map mapping) {
        if (mapping == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap mappedAttributesBuilder = new HashMap();
        Iterator sourceAttrNameItr = mapping.keySet().iterator();
        while (sourceAttrNameItr.hasNext()) {
            Object key = sourceAttrNameItr.next();
            if (key == null) {
                throw new IllegalArgumentException("The map from attribute names to attributes must not have any null keys.");
            }
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("The map from attribute names to attributes must only have String keys.  Encountered a key of class [" + key.getClass().getName() + "]");
            }
            String sourceAttrName = (String)key;
            Object mappedAttribute = mapping.get(sourceAttrName);
            if (mappedAttribute == null) {
                mappedAttributesBuilder.put(sourceAttrName, null);
                continue;
            }
            if (mappedAttribute instanceof String) {
                Set mappedSet = Collections.singleton(mappedAttribute);
                mappedAttributesBuilder.put(sourceAttrName, mappedSet);
                continue;
            }
            if (mappedAttribute instanceof Set) {
                Set sourceSet = (Set)mappedAttribute;
                HashSet mappedSet = new HashSet();
                Iterator sourceSetItr = sourceSet.iterator();
                while (sourceSetItr.hasNext()) {
                    Object mappedAttributeName = sourceSetItr.next();
                    if (mappedAttributeName instanceof String) {
                        mappedSet.add(mappedAttributeName);
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid mapped type. key='" + sourceAttrName + "', value type='" + mappedAttribute.getClass().getName() + "', sub value type='" + mappedAttributeName.getClass().getName() + "'");
                }
                mappedAttributesBuilder.put(sourceAttrName, Collections.unmodifiableSet(mappedSet));
                continue;
            }
            throw new IllegalArgumentException("Invalid mapped type. key='" + sourceAttrName + "', value type='" + mappedAttribute.getClass().getName() + "'");
        }
        return Collections.unmodifiableMap(mappedAttributesBuilder);
    }

    public static void addResult(Map results, Object key, Object value) {
        if (results == null) {
            throw new IllegalArgumentException("Cannot add a result to a null map.");
        }
        if (key == null) {
            throw new IllegalArgumentException("Cannot add a result with a null key.");
        }
        if (value == null) {
            return;
        }
        Object currentValue = results.get(key);
        if (currentValue == null) {
            results.put(key, value);
        } else if (value instanceof List) {
            List newValues = (List)value;
            if (currentValue instanceof List) {
                List values = (List)currentValue;
                values.addAll(newValues);
                results.put(key, values);
            } else {
                ArrayList values = new ArrayList(newValues.size() + 1);
                values.add(currentValue);
                values.addAll(newValues);
                results.put(key, values);
            }
        } else if (currentValue instanceof List) {
            List values = (List)currentValue;
            values.add(value);
            results.put(key, values);
        } else {
            ArrayList<Object> values = new ArrayList<Object>(2);
            values.add(currentValue);
            values.add(value);
            results.put(key, values);
        }
    }

    public static Collection flattenCollection(Collection source) {
        if (source == null) {
            throw new IllegalArgumentException("Cannot flatten a null collection.");
        }
        LinkedList result = new LinkedList();
        Iterator setItr = source.iterator();
        while (setItr.hasNext()) {
            Object value = setItr.next();
            if (value instanceof Collection) {
                Collection flatCollection = MultivaluedPersonAttributeUtils.flattenCollection((Collection)value);
                result.addAll(flatCollection);
                continue;
            }
            result.add(value);
        }
        return result;
    }

    private MultivaluedPersonAttributeUtils() {
    }
}

