/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.jdbc;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.jasig.services.persondir.support.MultivaluedPersonAttributeUtils;
import org.jasig.services.persondir.support.jdbc.AbstractJdbcPersonAttributeDao;
import org.jasig.services.persondir.support.jdbc.AbstractPersonAttributeMappingQuery;
import org.jasig.services.persondir.support.jdbc.MultiRowPersonAttributeMappingQuery;

public class MultiRowJdbcPersonAttributeDao
extends AbstractJdbcPersonAttributeDao {
    private Map attributeNameMappings = Collections.EMPTY_MAP;
    private Map nameValueColumnMappings = null;
    private Set userAttributes = Collections.EMPTY_SET;
    private final MultiRowPersonAttributeMappingQuery query;

    public MultiRowJdbcPersonAttributeDao(DataSource ds, List attrList, String sql) {
        if (ds == null) {
            throw new IllegalArgumentException("DataSource can not be null");
        }
        if (sql == null) {
            throw new IllegalArgumentException("The sql can not be null");
        }
        this.setQueryAttributes(attrList);
        List queryAttributes = this.getQueryAttributes();
        this.query = new MultiRowPersonAttributeMappingQuery(ds, sql, queryAttributes, this);
    }

    public Map parseAttributeMapFromResults(List queryResults) {
        HashMap results = new HashMap();
        Iterator rowItr = queryResults.iterator();
        while (rowItr.hasNext()) {
            Map rowResult = (Map)rowItr.next();
            Iterator resultItr = rowResult.entrySet().iterator();
            while (resultItr.hasNext()) {
                Map.Entry entry = resultItr.next();
                String srcAttrName = (String)entry.getKey();
                Set portalAttrNames = (Set)this.attributeNameMappings.get(srcAttrName);
                if (portalAttrNames == null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Adding un-mapped attribute '" + srcAttrName + "'"));
                    }
                    MultivaluedPersonAttributeUtils.addResult(results, srcAttrName, entry.getValue());
                    continue;
                }
                Iterator upAttrNameItr = portalAttrNames.iterator();
                while (upAttrNameItr.hasNext()) {
                    String portalAttrName = (String)upAttrNameItr.next();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Adding mapped attribute '" + portalAttrName + "' for source attribute '" + srcAttrName + "'"));
                    }
                    MultivaluedPersonAttributeUtils.addResult(results, portalAttrName, entry.getValue());
                }
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Mapped " + results.size() + " portal attributes from " + queryResults.size() + " source attributes"));
        }
        return results;
    }

    protected AbstractPersonAttributeMappingQuery getAttributeQuery() {
        return this.query;
    }

    public Set getPossibleUserAttributeNames() {
        return this.userAttributes;
    }

    public Map getAttributeNameMappings() {
        return this.attributeNameMappings;
    }

    public void setAttributeNameMappings(Map attributeNameMap) {
        if (attributeNameMap == null) {
            throw new IllegalArgumentException("columnsToAttributesMap may not be null");
        }
        this.attributeNameMappings = MultivaluedPersonAttributeUtils.parseAttributeToAttributeMapping(attributeNameMap);
        if (this.attributeNameMappings.containsKey("")) {
            throw new IllegalArgumentException("The map from attribute names to attributes must not have any empty keys.");
        }
        Collection userAttributeCol = MultivaluedPersonAttributeUtils.flattenCollection(this.attributeNameMappings.values());
        this.userAttributes = Collections.unmodifiableSet(new HashSet(userAttributeCol));
    }

    public Map getNameValueColumnMappings() {
        return this.nameValueColumnMappings;
    }

    public void setNameValueColumnMappings(Map nameValueColumnMap) {
        if (nameValueColumnMap == null) {
            this.nameValueColumnMappings = null;
        } else {
            Map mappings = MultivaluedPersonAttributeUtils.parseAttributeToAttributeMapping(nameValueColumnMap);
            if (mappings.containsValue(null)) {
                throw new IllegalArgumentException("nameValueColumnMap may not have null values");
            }
            this.nameValueColumnMappings = mappings;
        }
    }
}

