/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.jasig.services.persondir.support.MultivaluedPersonAttributeUtils;
import org.jasig.services.persondir.support.jdbc.AbstractPersonAttributeMappingQuery;
import org.jasig.services.persondir.support.jdbc.SingleRowJdbcPersonAttributeDao;

class SingleRowPersonAttributeMappingQuery
extends AbstractPersonAttributeMappingQuery {
    private final SingleRowJdbcPersonAttributeDao parentSingleRowPersonAttributeDao;

    public SingleRowPersonAttributeMappingQuery(DataSource ds, String sql, List queryAttributes, SingleRowJdbcPersonAttributeDao parentSingleRowPersonAttributeDao) {
        super(ds, sql, queryAttributes);
        if (parentSingleRowPersonAttributeDao == null) {
            throw new IllegalArgumentException("parentSingleRowPersonAttributeDao may not be null");
        }
        this.parentSingleRowPersonAttributeDao = parentSingleRowPersonAttributeDao;
    }

    protected Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        HashMap rowResults = new HashMap();
        Map attributeMappings = this.parentSingleRowPersonAttributeDao.getColumnsToAttributes();
        Iterator columnNameItr = attributeMappings.keySet().iterator();
        while (columnNameItr.hasNext()) {
            String columnName = (String)columnNameItr.next();
            this.addMappedAttributes(rs, columnName, rowResults);
        }
        return rowResults;
    }

    private void addMappedAttributes(ResultSet rs, String columnName, Map rowResults) throws SQLException {
        if (columnName == null || columnName.length() <= 0) {
            throw new IllegalArgumentException("columnName cannot be null and must have length >= 0");
        }
        String attributeValue = null;
        try {
            attributeValue = rs.getString(columnName);
        }
        catch (SQLException sqle) {
            this.logger.error((Object)("Was unable to read attribute for column [" + columnName + "]"));
            throw sqle;
        }
        Map attributeMappings = this.parentSingleRowPersonAttributeDao.getColumnsToAttributes();
        Set<String> attributeNames = (Set<String>)attributeMappings.get(columnName);
        if (attributeNames == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No mapped attribute name for column='" + columnName + "', defaulting to the column name."));
            }
            attributeNames = Collections.singleton(columnName);
        }
        Iterator attrNameItr = attributeNames.iterator();
        while (attrNameItr.hasNext()) {
            String attributeName = (String)attrNameItr.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Adding mapped attribute '" + attributeName + "' for source column '" + columnName + "'"));
            }
            MultivaluedPersonAttributeUtils.addResult(rowResults, attributeName, attributeValue);
        }
    }
}

