/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.services;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.descriptors.portlet.PortletAppDD;
import org.apache.pluto.descriptors.portlet.UserAttributeDD;
import org.apache.pluto.internal.InternalPortletRequest;
import org.apache.pluto.internal.InternalPortletWindow;
import org.apache.pluto.spi.optional.UserInfoService;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.factory.annotation.Required;

public class SamlAssertionUserInfoService
implements UserInfoService {
    private IUserInstanceManager userInstanceManager;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortletEntityRegistry portletEntityRegistry;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortalRequestUtils portalRequestUtils;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String samlAssertionKey = "samlAssertion";
    private String idpPublicKeysKey = "idpPublicKeys";
    private String samlAssertionSessionKey = "samlAssertion";
    private String idpPublicKeysSessionKey = "idpPublicKeys";

    public IPortalRequestUtils getPortalRequestUtils() {
        return this.portalRequestUtils;
    }

    @Required
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        Validate.notNull((Object)portalRequestUtils);
        this.portalRequestUtils = portalRequestUtils;
    }

    public void setIdpPublicKeysKey(String idpPublicKeysKey) {
        this.idpPublicKeysKey = idpPublicKeysKey;
    }

    public void setIdpPublicKeysSessionKey(String idpPublicKeysSessionKey) {
        this.idpPublicKeysSessionKey = idpPublicKeysSessionKey;
    }

    public String getSamlAssertionSessionKey() {
        return this.samlAssertionSessionKey;
    }

    public void setSamlAssertionSessionKey(String samlAssertionSessionKey) {
        this.samlAssertionSessionKey = samlAssertionSessionKey;
    }

    public IUserInstanceManager getUserInstanceManager() {
        return this.userInstanceManager;
    }

    @Required
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    public IPortletEntityRegistry getPortletEntityRegistry() {
        return this.portletEntityRegistry;
    }

    @Required
    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        this.portletEntityRegistry = portletEntityRegistry;
    }

    public IPortletWindowRegistry getPortletWindowRegistry() {
        return this.portletWindowRegistry;
    }

    @Required
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    public IPortletDefinitionRegistry getPortletDefinitionRegistry() {
        return this.portletDefinitionRegistry;
    }

    @Required
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    public String getSamlAssertionKey() {
        return this.samlAssertionKey;
    }

    public void setSamlAssertionKey(String samlAssertionKey) {
        this.samlAssertionKey = samlAssertionKey;
    }

    @Deprecated
    public Map getUserInfo(PortletRequest request) throws PortletContainerException {
        if (!(request instanceof InternalPortletRequest)) {
            throw new IllegalArgumentException("The SamlAssertionUserInfoService requires the PortletRequest parameter to implement the '" + InternalPortletRequest.class.getName() + "' interface.");
        }
        InternalPortletRequest internalRequest = (InternalPortletRequest)request;
        InternalPortletWindow internalPortletWindow = internalRequest.getInternalPortletWindow();
        return this.getUserInfo(request, (PortletWindow)internalPortletWindow);
    }

    public Map getUserInfo(PortletRequest request, PortletWindow portletWindow) throws PortletContainerException {
        HttpSession session;
        HttpServletRequest httpServletRequest;
        LinkedHashMap<String, String> userInfo = new LinkedHashMap<String, String>();
        if (this.isSamlAssertionRequested(request, portletWindow)) {
            httpServletRequest = this.portalRequestUtils.getOriginalPortletAdaptorRequest(request);
            session = httpServletRequest.getSession();
            String samlArtifact = (String)session.getAttribute(this.samlAssertionSessionKey);
            if (samlArtifact != null) {
                userInfo.put(this.samlAssertionKey, samlArtifact);
            } else {
                this.logger.warn((Object)("Portlet " + portletWindow.getPortletName() + " requested SAML assertion, but none was provided."));
            }
        }
        if (this.areIdPKeysRequested(request, portletWindow)) {
            httpServletRequest = this.portalRequestUtils.getOriginalPortletAdaptorRequest(request);
            session = httpServletRequest.getSession();
            String idpArtifact = (String)session.getAttribute(this.idpPublicKeysSessionKey);
            if (idpArtifact != null) {
                userInfo.put(this.idpPublicKeysKey, idpArtifact);
            } else {
                this.logger.warn((Object)("Portlet " + portletWindow.getPortletName() + " requested IdP public key, but none was provided."));
            }
        }
        return userInfo;
    }

    protected boolean isSamlAssertionRequested(PortletRequest request, PortletWindow plutoPortletWindow) throws PortletContainerException {
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getOriginalPortletAdaptorRequest(request);
        IPortletWindow portletWindow = this.portletWindowRegistry.convertPortletWindow(httpServletRequest, plutoPortletWindow);
        IPortletEntity portletEntity = this.portletWindowRegistry.getParentPortletEntity(httpServletRequest, portletWindow.getPortletWindowId());
        IPortletDefinition portletDefinition = this.portletEntityRegistry.getParentPortletDefinition(portletEntity.getPortletEntityId());
        PortletAppDD portletApplicationDescriptor = this.portletDefinitionRegistry.getParentPortletApplicationDescriptor(portletDefinition.getPortletDefinitionId());
        List requestedUserAttributes = portletApplicationDescriptor.getUserAttributes();
        for (UserAttributeDD userAttributeDD : requestedUserAttributes) {
            String attributeName = userAttributeDD.getName();
            if (!attributeName.equals(this.samlAssertionKey)) continue;
            return true;
        }
        return false;
    }

    protected boolean areIdPKeysRequested(PortletRequest request, PortletWindow plutoPortletWindow) throws PortletContainerException {
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getOriginalPortletAdaptorRequest(request);
        IPortletWindow portletWindow = this.portletWindowRegistry.convertPortletWindow(httpServletRequest, plutoPortletWindow);
        IPortletEntity portletEntity = this.portletWindowRegistry.getParentPortletEntity(httpServletRequest, portletWindow.getPortletWindowId());
        IPortletDefinition portletDefinition = this.portletEntityRegistry.getParentPortletDefinition(portletEntity.getPortletEntityId());
        PortletAppDD portletApplicationDescriptor = this.portletDefinitionRegistry.getParentPortletApplicationDescriptor(portletDefinition.getPortletDefinitionId());
        List requestedUserAttributes = portletApplicationDescriptor.getUserAttributes();
        for (UserAttributeDD userAttributeDD : requestedUserAttributes) {
            String attributeName = userAttributeDD.getName();
            if (!attributeName.equals(this.idpPublicKeysKey)) continue;
            return true;
        }
        return false;
    }
}

