/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import java.io.IOException;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.web.filter.GenericFilterBean;

public class SamlAssertionFilter
extends GenericFilterBean {
    private MultiThreadedHttpConnectionManager connectionManager = null;
    private HttpClient httpClient;
    private String samlAssertionSessionAttributeName = null;
    private String idpPublicKeysSessionAttributeName = null;
    private int maxTotalConnections = 200;
    private int connectionTimeout = (int)TimeUnit.SECONDS.convert(30L, TimeUnit.MILLISECONDS);
    private int readTimeout = (int)TimeUnit.SECONDS.convert(30L, TimeUnit.MILLISECONDS);

    public void setSamlAssertionSessionAttributeName(String samlAssertionSessionAttributeName) {
        this.samlAssertionSessionAttributeName = samlAssertionSessionAttributeName;
    }

    public void setIdpPublicKeysSessionAttributeName(String idpPublicKeysSessionAttributeName) {
        this.idpPublicKeysSessionAttributeName = idpPublicKeysSessionAttributeName;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    protected void initFilterBean() throws ServletException {
        this.connectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = this.connectionManager.getParams();
        params.setMaxTotalConnections(this.maxTotalConnections);
        params.setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, this.maxTotalConnections);
        params.setConnectionTimeout(this.connectionTimeout);
        params.setSoTimeout(this.readTimeout);
        this.httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
    }

    public void destroy() {
        this.httpClient = null;
        this.connectionManager.shutdown();
        this.connectionManager = null;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        this.doHttpFilter((HttpServletRequest)req, (HttpServletResponse)res, chain);
    }

    protected int getAssertionCount(HttpServletRequest req) {
        String assertionCountHeader = req.getHeader("Shib-Assertion-Count");
        return NumberUtils.toInt((String)assertionCountHeader, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHttpFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("HTTP headers: [" + this.headersAsString(req) + "]"));
        }
        int assertionCount = this.getAssertionCount(req);
        String idp = null;
        String assertion = null;
        String signingKeys = null;
        if (assertionCount > 0) {
            idp = req.getHeader("Shib-Identity-Provider");
            String firstAssertionHeader = req.getHeader("Shib-Assertion-01");
            if (this.idpPublicKeysSessionAttributeName != null) {
                signingKeys = req.getHeader("Meta-Signing-Keys");
            }
            if (StringUtils.isNotEmpty((String)firstAssertionHeader)) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Retrieving SAML assertion from the URL: " + firstAssertionHeader));
                }
                GetMethod method = new GetMethod(firstAssertionHeader);
                try {
                    int result = this.httpClient.executeMethod((HttpMethod)method);
                    if (result >= 200 && result < 300) {
                        assertion = method.getResponseBodyAsString();
                    }
                    this.logger.error((Object)("Unsupported HTTP result code when retrieving the SAML assertion: " + result));
                }
                catch (Exception ex) {
                    this.logger.error((Object)"Exception caught when trying to retrieve SAML assertion.", (Throwable)ex);
                }
                finally {
                    method.releaseConnection();
                }
            } else {
                this.logger.error((Object)("SAML assertion URL not present, but the assertion count was " + assertionCount + "."));
            }
        } else {
            this.logger.warn((Object)"SAML assertion count not present or zero");
        }
        try {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
        finally {
            HttpSession session = req.getSession();
            if (assertion != null) {
                session.setAttribute(this.samlAssertionSessionAttributeName, assertion);
            }
            if (idp != null) {
                session.setAttribute("IdP", (Object)idp);
            }
            if (signingKeys != null) {
                session.setAttribute(this.idpPublicKeysSessionAttributeName, (Object)signingKeys);
            }
        }
    }

    private String headersAsString(HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        Enumeration headers = req.getHeaderNames();
        while (headers.hasMoreElements()) {
            String headerName = (String)headers.nextElement();
            String headerValue = req.getHeader(headerName);
            sb.append(headerName).append("=").append(headerValue).append(", ");
        }
        return sb.toString();
    }
}

