/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.connection_config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.javalite.activejdbc.Configuration;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.connection_config.ConnectionJdbcSpec;
import org.javalite.activejdbc.connection_config.ConnectionJndiSpec;
import org.javalite.activejdbc.connection_config.ConnectionSpecWrapper;
import org.javalite.common.Util;

public class DbConfiguration {
    private static HashMap<String, List<ConnectionSpecWrapper>> connectionWrappers = new HashMap();
    private String configFile;

    public static void addConnectionWrapper(ConnectionSpecWrapper connectionWrapper, boolean override) {
        String connectionWrapperEnv = connectionWrapper.getEnvironment();
        List<ConnectionSpecWrapper> envConnectionWrappers = connectionWrappers.get(connectionWrapperEnv);
        if (envConnectionWrappers == null || override) {
            envConnectionWrappers = new ArrayList<ConnectionSpecWrapper>();
            connectionWrappers.put(connectionWrapperEnv, envConnectionWrappers);
        }
        envConnectionWrappers.add(connectionWrapper);
    }

    public static List<ConnectionSpecWrapper> getConnectionSpecWrappers() {
        return DbConfiguration.getConnectionSpecWrappers(Configuration.getEnv());
    }

    public static List<ConnectionSpecWrapper> getConnectionSpecWrappers(String env) {
        return connectionWrappers.get(env) == null ? new ArrayList() : connectionWrappers.get(env);
    }

    public static void clearConnectionWrappers() {
        DbConfiguration.clearConnectionWrappers(Configuration.getEnv());
    }

    public static void resetConnectionWrappers() {
        connectionWrappers = new HashMap();
    }

    protected static void clearConnectionWrappers(String env) {
        if (connectionWrappers.get(env) != null) {
            connectionWrappers.get(env).clear();
        }
    }

    public void loadConfiguration(String file) {
        if (this.configFile == null) {
            try {
                Properties props = Util.readProperties((String)file);
                Set environments = props.stringPropertyNames().stream().map(n -> n.substring(0, n.lastIndexOf("."))).collect(Collectors.toSet());
                for (String env : environments) {
                    String jndiName = env + "." + "jndi";
                    if (props.containsKey(jndiName)) {
                        this.createJndiWrapper(env, props.getProperty(jndiName));
                        continue;
                    }
                    String driver = props.getProperty(env + ".driver");
                    String userName = props.getProperty(env + ".username");
                    String password = props.getProperty(env + ".password");
                    String url = props.getProperty(env + ".url");
                    this.checkProps(driver, userName, password, url, env);
                    this.createJdbcWrapper(env, driver, url, userName, password);
                }
            }
            catch (InitException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InitException(e);
            }
        }
    }

    private void checkProps(String driver, String userName, String password, String url, String env) {
        if (driver == null || userName == null || password == null || url == null) {
            throw new InitException("Four JDBC properties are expected: driver, username, password, url for environment: " + env);
        }
    }

    private void createJdbcWrapper(String env, String driver, String url, String userName, String password) {
        ConnectionSpecWrapper wrapper = new ConnectionSpecWrapper();
        if (env.equals("test")) {
            wrapper.setEnvironment("development");
            wrapper.setTesting(true);
        } else if (env.endsWith(".test")) {
            wrapper.setEnvironment(env.split("\\.")[0]);
            wrapper.setTesting(true);
        } else {
            wrapper.setEnvironment(env);
        }
        ConnectionJdbcSpec connectionSpec = new ConnectionJdbcSpec(driver, url, userName, password);
        wrapper.setConnectionSpec(connectionSpec);
        DbConfiguration.addConnectionWrapper(wrapper, false);
    }

    private void createJndiWrapper(String env, String jndiName) {
        ConnectionSpecWrapper wrapper = new ConnectionSpecWrapper();
        wrapper.setEnvironment(env);
        ConnectionJndiSpec connectionSpec = new ConnectionJndiSpec(jndiName);
        wrapper.setConnectionSpec(connectionSpec);
        DbConfiguration.addConnectionWrapper(wrapper, false);
    }

    public List<ConnectionSpecWrapper> getTestConnectionWrappers() {
        List<ConnectionSpecWrapper> allConnections = DbConfiguration.getConnectionSpecWrappers();
        LinkedList<ConnectionSpecWrapper> result = new LinkedList<ConnectionSpecWrapper>();
        for (ConnectionSpecWrapper connectionWrapper : allConnections) {
            if (!connectionWrapper.isTesting()) continue;
            result.add(connectionWrapper);
        }
        return result;
    }
}

