/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.logging;

import java.util.regex.Pattern;
import org.javalite.activejdbc.Configuration;
import org.javalite.activejdbc.Registry;
import org.javalite.activejdbc.logging.LogLevel;
import org.javalite.activejdbc.statistics.QueryExecutionEvent;
import org.javalite.common.JsonHelper;
import org.slf4j.Logger;

public class LogFilter {
    private static Pattern pattern;

    private LogFilter() {
    }

    public static void setLogExpression(String regexp) {
        pattern = Pattern.compile(regexp, 2);
    }

    public static void logQuery(Logger logger, String query, Object[] params, long queryStartTime) {
        long time = System.currentTimeMillis() - queryStartTime;
        LogFilter.log(logger, LogLevel.INFO, LogFilter.getJson(query, params, time));
    }

    public static void logQuery(Logger logger, String query, Object[] params, long queryStartTime, boolean cacheHit) {
        long time = System.currentTimeMillis() - queryStartTime;
        LogFilter.log(logger, LogLevel.INFO, LogFilter.getJson(query, params, time, cacheHit));
    }

    private static String getJson(String query, Object[] params, long time) {
        if (Registry.instance().getConfiguration().collectStatistics()) {
            Registry.instance().getStatisticsQueue().enqueue(new QueryExecutionEvent(query, time));
        }
        return "{\"sql\":\"" + query.replace("\"", "'") + "\",\"params\":[" + LogFilter.getParamsJson(params) + "]" + ",\"duration_millis\":" + time + "}";
    }

    private static String getJson(String query, Object[] params, long time, boolean cacheHit) {
        if (Registry.instance().getConfiguration().collectStatistics() && !cacheHit) {
            Registry.instance().getStatisticsQueue().enqueue(new QueryExecutionEvent(query, time));
        }
        return "{\"sql\":\"" + JsonHelper.sanitize((String)query) + "\",\"params\":[" + LogFilter.getParamsJson(params) + "]" + (!cacheHit ? ",\"duration_millis\":" + time : "") + ",\"cache\":" + (cacheHit ? "\"hit\"" : "\"miss\"") + "}";
    }

    private static String getParamsJson(Object[] params) {
        StringBuilder paramsSB = new StringBuilder("");
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i] instanceof Number) {
                    paramsSB.append(JsonHelper.sanitize((String)params[i].toString()));
                } else if (params[i] instanceof byte[]) {
                    paramsSB.append("\"bytes[...]\"");
                } else if (params[i] == null) {
                    paramsSB.append("null");
                } else {
                    paramsSB.append("\"").append(JsonHelper.sanitize((String)params[i].toString())).append("\"");
                }
                if (i == params.length - 1) continue;
                paramsSB.append(",");
            }
        }
        return paramsSB.toString();
    }

    public static void log(Logger logger, LogLevel logLevel, String log) {
        if (Configuration.hasActiveLogger()) {
            Configuration.getActiveLogger().log(logger, logLevel, log);
        } else if (pattern.matcher(log).matches()) {
            switch (logLevel) {
                case DEBUG: {
                    logger.debug(log);
                    break;
                }
                case INFO: {
                    logger.info(log);
                    break;
                }
                case WARNING: {
                    logger.warn(log);
                    break;
                }
                case ERROR: {
                    logger.error(log);
                    break;
                }
            }
        }
    }

    public static void log(Logger logger, LogLevel logLevel, String log, Object param) {
        if (Configuration.hasActiveLogger()) {
            Configuration.getActiveLogger().log(logger, logLevel, log, param);
        } else if (pattern.matcher(log).matches()) {
            switch (logLevel) {
                case DEBUG: {
                    logger.debug(log, param);
                    break;
                }
                case INFO: {
                    logger.info(log, param);
                    break;
                }
                case WARNING: {
                    logger.warn(log, param);
                    break;
                }
                case ERROR: {
                    logger.error(log, param);
                    break;
                }
            }
        }
    }

    public static void log(Logger logger, LogLevel logLevel, String log, Object param1, Object param2) {
        if (Configuration.hasActiveLogger()) {
            Configuration.getActiveLogger().log(logger, logLevel, log, param1, param2);
        } else if (pattern.matcher(log).matches()) {
            switch (logLevel) {
                case DEBUG: {
                    logger.debug(log, param1, param2);
                    break;
                }
                case INFO: {
                    logger.info(log, param1, param2);
                    break;
                }
                case WARNING: {
                    logger.warn(log, param1, param2);
                    break;
                }
                case ERROR: {
                    logger.error(log, param1, param2);
                    break;
                }
            }
        }
    }

    public static void log(Logger logger, LogLevel logLevel, String log, Object ... params) {
        if (Configuration.hasActiveLogger()) {
            Configuration.getActiveLogger().log(logger, logLevel, log, params);
        } else if (pattern.matcher(log).matches()) {
            switch (logLevel) {
                case DEBUG: {
                    logger.debug(log, params);
                    break;
                }
                case INFO: {
                    logger.info(log, params);
                    break;
                }
                case WARNING: {
                    logger.warn(log, params);
                    break;
                }
                case ERROR: {
                    logger.error(log, params);
                    break;
                }
            }
        }
    }

    static {
        String logFlag = System.getProperty("activejdbc.log");
        if (logFlag != null && logFlag.equals("")) {
            LogFilter.setLogExpression(".*");
        } else if (logFlag != null) {
            LogFilter.setLogExpression(logFlag);
        } else {
            LogFilter.setLogExpression("a{10000000}");
        }
    }
}

